export declare type i18nLanguageIdentifier = 'aboutReleases' | 'aboutUpdate' | 'aboutVersion' | 'aboutWebappVersion' | 'certificateVerifyProcManagerRetry' | 'certificateVerifyProcManagerShowDetails' | 'certificateVerifyProcManagerShowDetailsGoBack' | 'certificateVerifyProcManagerShowDetailsSaveCertificate' | 'certificateVerifyProcManagerShowDetailsTextChromium' | 'certificateVerifyProcManagerShowDetailsTextPinning' | 'certificateVerifyProcManagerShowDetailsTitle' | 'certificateVerifyProcManagerWarningBypass' | 'certificateVerifyProcManagerWarningTextChromium' | 'certificateVerifyProcManagerWarningTextPinning' | 'certificateVerifyProcManagerWarningTitle' | 'changeEnvironmentModalConfirm' | 'changeEnvironmentModalText' | 'changeEnvironmentModalTitle' | 'menuAbout' | 'menuActualSize' | 'menuAddPeople' | 'menuAppURL' | 'menuArchive' | 'menuBlock' | 'menuCall' | 'menuClose' | 'menuConversation' | 'menuCopy' | 'menuCopyPicture' | 'menuCut' | 'menuDelete' | 'menuDownloadDebugLogs' | 'menuEdit' | 'menuEnableSpellChecking' | 'menuFullScreen' | 'menuHelp' | 'menuHideApp' | 'menuHideOthers' | 'menuLeave' | 'menuLegal' | 'menuLicense' | 'menuLocale' | 'menuMinimize' | 'menuMute' | 'menuNextConversation' | 'menuNoSuggestions' | 'menuNotificationSettings' | 'menuPaste' | 'menuPeople' | 'menuPing' | 'menuPreferences' | 'menuPreviousConversation' | 'menuPrivacy' | 'menuQuit' | 'menuRedo' | 'menuSavePictureAs' | 'menuSelectAll' | 'menuServices' | 'menuSettings' | 'menuShowAll' | 'menuShowHide' | 'menuSignOut' | 'menuStart' | 'menuStartup' | 'menuSupport' | 'menuSwitchAccount' | 'menuUnarchive' | 'menuUndo' | 'menuVideoCall' | 'menuView' | 'menuWindow' | 'menuZoomIn' | 'menuZoomOut' | 'promptCancel' | 'promptError' | 'promptOK' | 'promptWarning' | 'proxyPromptHeadline' | 'proxyPromptPassword' | 'proxyPromptTitle' | 'proxyPromptUsername' | 'restartLater' | 'restartLocale' | 'restartNeeded' | 'restartNow' | 'trayOpen' | 'trayQuit' | 'unreadMessages' | 'urlBlockedPromptText' | 'webviewErrorDescription' | 'webviewErrorDescriptionSub' | 'webviewErrorRetryAction' | 'webviewErrorTitle' | 'wrapperAddAccount' | 'wrapperAddAccountErrorMessagePlural' | 'wrapperAddAccountErrorMessageSingular' | 'wrapperAddAccountErrorTitlePlural' | 'wrapperAddAccountErrorTitleSingular' | 'wrapperCreateTeam' | 'wrapperLogOut' | 'wrapperManageTeam' | 'wrapperRemoveAccount';
export declare type i18nStrings = Record<i18nLanguageIdentifier, string>;
export declare type SupportedI18nLanguage = keyof typeof SUPPORTED_LANGUAGES;
export declare type SupportedI18nLanguageObject = Record<SupportedI18nLanguage, i18nStrings>;
export declare const LANGUAGES: SupportedI18nLanguageObject;
export declare const supportedSpellCheckLanguages: Record<SupportedI18nLanguage, string[]>;
export declare const SUPPORTED_LANGUAGES: {
    en: string;
    cs: string;
    da: string;
    de: string;
    el: string;
    et: string;
    es: string;
    fr: string;
    hr: string;
    it: string;
    lt: string;
    hu: string;
    nl: string;
    pl: string;
    pt: string;
    ro: string;
    ru: string;
    si: string;
    sk: string;
    sl: string;
    fi: string;
    tr: string;
    uk: string;
    zh: string;
};
export declare const getCurrent: () => SupportedI18nLanguage;
export declare const getText: (stringIdentifier: i18nLanguageIdentifier, paramReplacements?: Record<string, string> | undefined) => string;
export declare const setLocale: (locale: string) => void;
