"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.setLocale = exports.getText = exports.getCurrent = exports.SUPPORTED_LANGUAGES = exports.supportedSpellCheckLanguages = exports.LANGUAGES = void 0;
const Electron = __importStar(require("electron"));
const config_1 = require("../settings/config");
const ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
const SettingsType_1 = require("../settings/SettingsType");
const cs_CZ = require('../../locale/cs-CZ');
const da_DK = require('../../locale/da-DK');
const de_DE = require('../../locale/de-DE');
const el_GR = require('../../locale/el-GR');
const en_US = require('../../locale/en-US');
const es_ES = require('../../locale/es-ES');
const et_EE = require('../../locale/et-EE');
const fi_FI = require('../../locale/fi-FI');
const fr_FR = require('../../locale/fr-FR');
const hr_HR = require('../../locale/hr-HR');
const hu_HU = require('../../locale/hu-HU');
const it_IT = require('../../locale/it-IT');
const lt_LT = require('../../locale/lt-LT');
const nl_NL = require('../../locale/nl-NL');
const pl_PL = require('../../locale/pl-PL');
const pt_BR = require('../../locale/pt-BR');
const ro_RO = require('../../locale/ro-RO');
const ru_RU = require('../../locale/ru-RU');
const si_LK = require('../../locale/si-LK');
const sk_SK = require('../../locale/sk-SK');
const sl_SI = require('../../locale/sl-SI');
const tr_TR = require('../../locale/tr-TR');
const uk_UA = require('../../locale/uk-UA');
const zh_CN = require('../../locale/zh-CN');
const app = Electron.app || Electron.remote.app;
exports.LANGUAGES = {
    cs: cs_CZ,
    da: da_DK,
    de: de_DE,
    el: el_GR,
    en: en_US,
    es: es_ES,
    et: et_EE,
    fi: fi_FI,
    fr: fr_FR,
    hr: hr_HR,
    hu: hu_HU,
    it: it_IT,
    lt: lt_LT,
    nl: nl_NL,
    pl: pl_PL,
    pt: pt_BR,
    ro: ro_RO,
    ru: ru_RU,
    si: si_LK,
    sk: sk_SK,
    sl: sl_SI,
    tr: tr_TR,
    uk: uk_UA,
    zh: zh_CN,
};
exports.supportedSpellCheckLanguages = {
    cs: ['cs', 'cs-CZ'],
    da: ['da', 'da-DK'],
    de: ['de', 'de-DE'],
    el: ['el', 'el-GR'],
    en: ['en', 'en-US'],
    es: ['es', 'es-ES'],
    et: ['et', 'et-EE'],
    fi: ['fi', 'fi-FI'],
    fr: ['fr', 'fr-FR'],
    hr: ['hr', 'hr-HR'],
    hu: ['hu', 'hu-HU'],
    it: ['it', 'it-IT'],
    lt: ['lt', 'lt-LT'],
    nl: ['nl', 'nl-NL'],
    pl: ['pl', 'pl-PL'],
    pt: ['pt', 'pt-BR'],
    ro: ['ro', 'ro-RO'],
    ru: ['ru', 'ru-RU'],
    si: ['si', 'si-LK'],
    sk: ['sk', 'sk-SK'],
    sl: ['sl', 'sl-SI'],
    tr: ['tr', 'tr-TR'],
    uk: ['uk', 'uk-UA'],
    zh: ['zh', 'zh-CN'],
};
exports.SUPPORTED_LANGUAGES = {
    en: 'English',
    cs: 'Čeština',
    da: 'Dansk',
    de: 'Deutsch',
    el: 'Ελληνικά',
    et: 'Eesti',
    es: 'Español',
    fr: 'Français',
    hr: 'Hrvatski',
    it: 'Italiano',
    lt: 'Lietuvos',
    hu: 'Magyar',
    nl: 'Nederlands',
    pl: 'Polski',
    pt: 'Português do Brasil',
    ro: 'Română',
    ru: 'Русский',
    si: 'සිංහල',
    sk: 'Slovenčina',
    sl: 'Slovenščina',
    fi: 'Suomi',
    tr: 'Türkçe',
    uk: 'Українська',
    zh: '简体中文',
};
let current;
const getCurrent = () => {
    if (!current) {
        const defaultLocale = parseLocale(app.getLocale().substr(0, 2));
        current = ConfigurationPersistence_1.settings.restore(SettingsType_1.SettingsType.LOCALE, defaultLocale);
    }
    return current;
};
exports.getCurrent = getCurrent;
const parseLocale = (locale) => {
    const languageKeys = Object.keys(exports.SUPPORTED_LANGUAGES);
    return languageKeys.find(languageKey => languageKey === locale) || languageKeys[0];
};
const customReplacements = {
    brandName: config_1.config.name,
};
const getText = (stringIdentifier, paramReplacements) => {
    const strings = exports.getCurrent();
    let translationText = exports.LANGUAGES[strings][stringIdentifier] || exports.LANGUAGES.en[stringIdentifier];
    if (!translationText) {
        throw new Error(`Translation for "${stringIdentifier}" could not be found.`);
    }
    const replacements = Object.assign(Object.assign({}, customReplacements), paramReplacements);
    for (const replacement of Object.keys(replacements)) {
        const regex = new RegExp(`{${replacement}}`, 'g');
        if (translationText.match(regex)) {
            translationText = translationText.replace(regex, replacements[replacement]);
        }
    }
    return translationText;
};
exports.getText = getText;
const setLocale = (locale) => {
    current = parseLocale(locale);
    ConfigurationPersistence_1.settings.save(SettingsType_1.SettingsType.LOCALE, current);
};
exports.setLocale = setLocale;
//# sourceMappingURL=locale.js.map