"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.developerMenu = exports.openDevTools = void 0;
const electron_1 = require("electron");
const EnvironmentUtil = __importStar(require("../runtime/EnvironmentUtil"));
const lifecycle = __importStar(require("../runtime/lifecycle"));
const config_1 = require("../settings/config");
const ElectronUtil_1 = require("../lib/ElectronUtil");
const WindowManager_1 = require("../window/WindowManager");
const currentEnvironment = EnvironmentUtil.getEnvironment();
const reloadTemplate = {
    click: () => { var _a; return (_a = WindowManager_1.WindowManager.getPrimaryWindow()) === null || _a === void 0 ? void 0 : _a.reload(); },
    label: 'Reload',
};
const openDevTools = (webViewIndex) => __awaiter(void 0, void 0, void 0, function* () {
    const primaryWindow = WindowManager_1.WindowManager.getPrimaryWindow();
    if (primaryWindow) {
        if (typeof webViewIndex === 'number' && webViewIndex > 0) {
            const snippet = `document.getElementsByTagName("webview")[${webViewIndex - 1}].openDevTools({mode: "detach"})`;
            yield ElectronUtil_1.executeJavaScriptWithoutResult(snippet, primaryWindow.webContents);
        }
        else {
            primaryWindow.webContents.toggleDevTools();
        }
    }
});
exports.openDevTools = openDevTools;
const devToolsTemplate = {
    label: 'Toggle DevTools',
    submenu: [
        {
            accelerator: 'Alt+CmdOrCtrl+I',
            click: () => exports.openDevTools(0),
            label: 'Sidebar',
        },
        {
            click: () => exports.openDevTools(1),
            label: 'First',
        },
        {
            click: () => exports.openDevTools(2),
            label: 'Second',
        },
        {
            click: () => exports.openDevTools(3),
            label: 'Third',
        },
    ],
};
const createEnvironmentTemplates = () => {
    const environmentTemplate = [];
    const environments = Object.assign({}, EnvironmentUtil.URL_WEBAPP);
    delete environments.CUSTOM;
    for (const [backendType, backendURL] of Object.entries(environments)) {
        environmentTemplate.push({
            checked: currentEnvironment === backendType,
            click: () => __awaiter(void 0, void 0, void 0, function* () {
                EnvironmentUtil.setEnvironment(backendType);
                yield lifecycle.relaunch();
            }),
            label: backendURL.replace(/^https?:\/\//, ''),
            type: 'radio',
        });
    }
    return environmentTemplate;
};
const versionTemplate = {
    enabled: false,
    label: `${config_1.config.name} Version ${config_1.config.version || 'Development'}`,
};
const chromeVersionTemplate = {
    enabled: false,
    label: `Chrome Version ${process.versions.chrome}`,
};
const electronVersionTemplate = {
    enabled: false,
    label: `Electron Version ${process.versions.electron}`,
};
const separatorTemplate = {
    type: 'separator',
};
const menuTemplate = {
    id: 'Developer',
    label: '&Developer',
    submenu: [
        devToolsTemplate,
        reloadTemplate,
        separatorTemplate,
        {
            enabled: false,
            label: 'Environment',
        },
        ...createEnvironmentTemplates(),
        separatorTemplate,
        versionTemplate,
        chromeVersionTemplate,
        electronVersionTemplate,
    ],
};
exports.developerMenu = new electron_1.MenuItem(menuTemplate);
//# sourceMappingURL=developer.js.map