"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
const electron_1 = require("electron");
const webapp_events_1 = require("@wireapp/webapp-events");
const path = __importStar(require("path"));
const eventType_1 = require("../lib/eventType");
const locale = __importStar(require("../locale/locale"));
const getLogger_1 = require("../logging/getLogger");
const EnvironmentUtil = __importStar(require("../runtime/EnvironmentUtil"));
const AutomatedSingleSignOn_1 = require("../sso/AutomatedSingleSignOn");
const logger = getLogger_1.getLogger(path.basename(__filename));
electron_1.webFrame.setVisualZoomLevelLimits(1, 1);
window.locStrings = locale.LANGUAGES[locale.getCurrent()];
window.locStringsDefault = locale.LANGUAGES.en;
window.locale = locale.getCurrent();
window.isMac = EnvironmentUtil.platform.IS_MAC_OS;
const getSelectedWebview = () => document.querySelector('.Webview:not(.hide)');
const getWebviewById = (id) => document.querySelector(`.Webview[data-accountid="${id}"]`);
const subscribeToMainProcessEvents = () => {
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACCOUNT.SSO_LOGIN, (_event, code) => new AutomatedSingleSignOn_1.AutomatedSingleSignOn().start(code));
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACTION.JOIN_CONVERSATION, (_event, { code, key }) => __awaiter(void 0, void 0, void 0, function* () {
        const selectedWebview = getSelectedWebview();
        if (selectedWebview) {
            yield selectedWebview.send(eventType_1.EVENT_TYPE.ACTION.JOIN_CONVERSATION, { code, key });
        }
    }));
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.UI.SYSTEM_MENU, (_event, action) => __awaiter(void 0, void 0, void 0, function* () {
        const selectedWebview = getSelectedWebview();
        if (selectedWebview) {
            yield selectedWebview.send(action);
        }
    }));
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH, (_event, hash) => __awaiter(void 0, void 0, void 0, function* () {
        const selectedWebview = getSelectedWebview();
        if (selectedWebview) {
            yield selectedWebview.send(eventType_1.EVENT_TYPE.WEBAPP.CHANGE_LOCATION_HASH, hash);
        }
    }));
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.EDIT.COPY, () => { var _a; return (_a = getSelectedWebview()) === null || _a === void 0 ? void 0 : _a.copy(); });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.EDIT.CUT, () => { var _a; return (_a = getSelectedWebview()) === null || _a === void 0 ? void 0 : _a.cut(); });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.EDIT.PASTE, () => { var _a; return (_a = getSelectedWebview()) === null || _a === void 0 ? void 0 : _a.paste(); });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.EDIT.REDO, () => { var _a; return (_a = getSelectedWebview()) === null || _a === void 0 ? void 0 : _a.redo(); });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.EDIT.SELECT_ALL, () => { var _a; return (_a = getSelectedWebview()) === null || _a === void 0 ? void 0 : _a.selectAll(); });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.EDIT.UNDO, () => { var _a; return (_a = getSelectedWebview()) === null || _a === void 0 ? void 0 : _a.undo(); });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.WRAPPER.RELOAD, () => {
        const webviews = document.querySelectorAll('webview');
        webviews.forEach(webview => webview.reload());
    });
    electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACTION.SWITCH_ACCOUNT, (event, accountIndex) => {
        window.dispatchEvent(new CustomEvent(eventType_1.EVENT_TYPE.ACTION.SWITCH_ACCOUNT, { detail: { accountIndex } }));
    });
};
const setupIpcInterface = () => {
    window.sendBadgeCount = (count, ignoreFlash) => {
        electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.UI.BADGE_COUNT, { count, ignoreFlash });
    };
    window.submitDeepLink = (url) => {
        electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ACTION.DEEP_LINK_SUBMIT, url);
    };
    window.sendDeleteAccount = (accountId, sessionID) => {
        return new Promise((resolve, reject) => {
            const accountWebview = getWebviewById(accountId);
            if (!accountWebview) {
                return reject(`Webview for account "${accountId}" does not exist`);
            }
            logger.info(`Processing deletion of "${accountId}"`);
            const viewInstanceId = accountWebview.getWebContentsId();
            electron_1.ipcRenderer.on(eventType_1.EVENT_TYPE.ACCOUNT.DATA_DELETED, () => resolve());
            electron_1.ipcRenderer.send(eventType_1.EVENT_TYPE.ACCOUNT.DELETE_DATA, viewInstanceId, accountId, sessionID);
        });
    };
    window.sendLogoutAccount = (accountId) => __awaiter(void 0, void 0, void 0, function* () {
        const accountWebview = getWebviewById(accountId);
        logger.log(`Sending logout signal to webview for account "${accountId}".`);
        yield (accountWebview === null || accountWebview === void 0 ? void 0 : accountWebview.send(eventType_1.EVENT_TYPE.ACTION.SIGN_OUT));
    });
    window.sendConversationJoinToHost = (accountId, code, key) => __awaiter(void 0, void 0, void 0, function* () {
        const accountWebview = getWebviewById(accountId);
        logger.log(`Sending conversation join data to webview for account "${accountId}".`);
        yield (accountWebview === null || accountWebview === void 0 ? void 0 : accountWebview.send(webapp_events_1.WebAppEvents.CONVERSATION.JOIN, { code, key }));
    });
};
const addDragRegion = () => {
    if (EnvironmentUtil.platform.IS_MAC_OS) {
        const titleBar = document.createElement('div');
        titleBar.className = 'drag-region';
        document.body.appendChild(titleBar);
    }
};
setupIpcInterface();
subscribeToMainProcessEvents();
window.addEventListener('DOMContentLoaded', addDragRegion);
window.addEventListener('focus', () => {
    const selectedWebview = getSelectedWebview();
    if (selectedWebview) {
        selectedWebview.blur();
        selectedWebview.focus();
    }
});
//# sourceMappingURL=preload-app.js.map