export declare enum BackendType {
    AVS = "AVS",
    CUSTOM = "CUSTOM",
    DEVELOPMENT = "DEVELOPMENT",
    EDGE = "EDGE",
    INTERNAL = "INTERNAL",
    LOCALHOST = "LOCALHOST",
    MASTER = "MASTER",
    PRODUCTION = "PRODUCTION",
    QA = "QA"
}
export declare const URL_WEBAPP: Record<BackendType, string>;
export declare const app: {
    ENV: "internal" | "production";
    IS_DEVELOPMENT: boolean;
    IS_PRODUCTION: boolean;
    UPDATE_URL_WIN: string;
};
export declare const getEnvironment: () => BackendType;
export declare const platform: {
    IS_LINUX: boolean;
    IS_MAC_OS: boolean;
    IS_WINDOWS: boolean;
};
export declare const linuxDesktop: {
    isGnomeX11: boolean;
    isPopOS: boolean;
    isUbuntuUnity: boolean;
};
export declare const setEnvironment: (env?: BackendType | undefined, customURL?: string | undefined) => void;
export declare const web: {
    getAdminUrl: (path?: string) => string;
    getWebappUrl: (env?: string | undefined) => string;
    getWebsiteUrl: (path?: string | undefined) => string;
};
