"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.relaunch = exports.quit = exports.getWebViewId = exports.checkSingleInstance = exports.initSquirrelListener = exports.isFirstInstance = void 0;
const electron_1 = require("electron");
const path = __importStar(require("path"));
const commons_1 = require("@wireapp/commons");
const eventType_1 = require("../lib/eventType");
const getLogger_1 = require("../logging/getLogger");
const ConfigurationPersistence_1 = require("../settings/ConfigurationPersistence");
const Squirrel = __importStar(require("../update/squirrel"));
const WindowManager_1 = require("../window/WindowManager");
const EnvironmentUtil = __importStar(require("./EnvironmentUtil"));
const logger = getLogger_1.getLogger(path.basename(__filename));
exports.isFirstInstance = undefined;
function initSquirrelListener() {
    return __awaiter(this, void 0, void 0, function* () {
        if (EnvironmentUtil.platform.IS_WINDOWS) {
            logger.info('Checking for Windows update ...');
            yield Squirrel.handleSquirrelArgs();
            electron_1.ipcMain.on(eventType_1.EVENT_TYPE.WRAPPER.UPDATE, () => Squirrel.installUpdate());
        }
    });
}
exports.initSquirrelListener = initSquirrelListener;
const checkSingleInstance = () => __awaiter(void 0, void 0, void 0, function* () {
    if (process.mas) {
        exports.isFirstInstance = true;
    }
    else {
        exports.isFirstInstance = electron_1.app.requestSingleInstanceLock();
        logger.info('Checking if we are the first instance ...', exports.isFirstInstance);
        if (!EnvironmentUtil.platform.IS_WINDOWS && !exports.isFirstInstance) {
            yield exports.quit(false);
        }
        else {
            electron_1.app.on('second-instance', () => WindowManager_1.WindowManager.showPrimaryWindow());
        }
    }
});
exports.checkSingleInstance = checkSingleInstance;
const getWebViewId = (contents) => {
    try {
        const currentLocation = new URL(contents.getURL());
        const webViewId = currentLocation.searchParams.get('id');
        return webViewId && commons_1.ValidationUtil.isUUIDv4(webViewId) ? webViewId : undefined;
    }
    catch (error) {
        return undefined;
    }
};
exports.getWebViewId = getWebViewId;
const quit = (clearCache = true) => __awaiter(void 0, void 0, void 0, function* () {
    var _a;
    logger.info('Initiating app quit ...');
    ConfigurationPersistence_1.settings.persistToFile();
    if (clearCache) {
        logger.info('Clearing cache ...');
        try {
            yield ((_a = electron_1.session.defaultSession) === null || _a === void 0 ? void 0 : _a.clearCache());
        }
        catch (error) {
            logger.error(error);
        }
    }
    logger.info('Exiting ...');
    electron_1.app.quit();
});
exports.quit = quit;
const relaunch = () => __awaiter(void 0, void 0, void 0, function* () {
    logger.info('Relaunching the app ...');
    if (EnvironmentUtil.platform.IS_MAC_OS) {
        WindowManager_1.WindowManager.sendActionToPrimaryWindow(eventType_1.EVENT_TYPE.WRAPPER.RELOAD);
    }
    else {
        electron_1.app.relaunch();
        yield exports.quit();
    }
});
exports.relaunch = relaunch;
//# sourceMappingURL=lifecycle.js.map