"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.settings = void 0;
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const getLogger_1 = require("../logging/getLogger");
const SchemaUpdater_1 = require("./SchemaUpdater");
require("../global");
class ConfigurationPersistence {
    constructor() {
        this.configFile = SchemaUpdater_1.SchemaUpdater.updateToVersion1();
        this.logger = getLogger_1.getLogger(path.basename(__filename));
        if (typeof global._ConfigurationPersistence === 'undefined') {
            global._ConfigurationPersistence = this.readFromFile();
        }
        this.logger.info('Initializing ConfigurationPersistence');
    }
    delete(name) {
        this.logger.info(`Deleting "${name}"`);
        delete global._ConfigurationPersistence[name];
        return true;
    }
    save(name, value) {
        this.logger.info(`Saving "${name}" with value:`, value);
        global._ConfigurationPersistence[name] = value;
        return true;
    }
    restore(name, defaultValue) {
        this.logger.info(`Restoring "${name}"`);
        const value = global._ConfigurationPersistence[name];
        return typeof value !== 'undefined' ? value : defaultValue;
    }
    persistToFile() {
        this.logger.info(`Saving configuration to persistent storage in "${this.configFile}":`, global._ConfigurationPersistence);
        try {
            return fs.outputJsonSync(this.configFile, global._ConfigurationPersistence, { spaces: 2 });
        }
        catch (error) {
            this.logger.error('An error occurred while persisting the configuration', error);
        }
    }
    readFromFile() {
        this.logger.info(`Reading config file from "${this.configFile}" ...`);
        try {
            const configContent = fs.readJSONSync(this.configFile);
            this.logger.info('Read config:', JSON.stringify(configContent));
            return configContent;
        }
        catch (error) {
            this.logger.warn('No config found');
            const schemataKeys = Object.keys(SchemaUpdater_1.SchemaUpdater.SCHEMATA);
            return SchemaUpdater_1.SchemaUpdater.SCHEMATA[schemataKeys[schemataKeys.length - 1]];
        }
    }
}
exports.settings = new ConfigurationPersistence();
//# sourceMappingURL=ConfigurationPersistence.js.map