"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.handleSquirrelArgs = exports.installUpdate = void 0;
const electron_1 = require("electron");
const commons_1 = require("@wireapp/commons");
const childProcess = __importStar(require("child_process"));
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const getLogger_1 = require("../logging/getLogger");
const EnvironmentUtil = __importStar(require("../runtime/EnvironmentUtil"));
const lifecycle = __importStar(require("../runtime/lifecycle"));
const config_1 = require("../settings/config");
const logger = getLogger_1.getLogger(path.basename(__filename));
const appFolder = path.resolve(process.execPath, '..');
const rootFolder = path.resolve(appFolder, '..');
const updateDotExe = path.join(rootFolder, 'Update.exe');
const linkName = `${config_1.config.name}.lnk`;
const windowsAppData = process.env.APPDATA;
const startShortcut = path.join(electron_1.app.getPath('appData'), `Microsoft/Windows/Start Menu/Programs/${config_1.config.name}.lnk`);
const desktopShortcut = path.join(electron_1.app.getPath('desktop'), `${config_1.config.name}.lnk`);
const quickLaunchShortcut = windowsAppData
    ? path.resolve(windowsAppData, 'Microsoft/Internet Explorer/Quick Launch/User Pinned/TaskBar', linkName)
    : '';
if (!windowsAppData && EnvironmentUtil.platform.IS_WINDOWS) {
    logger.error('No Windows AppData directory found.');
}
var SQUIRREL_EVENT;
(function (SQUIRREL_EVENT) {
    SQUIRREL_EVENT["INSTALL"] = "--squirrel-install";
    SQUIRREL_EVENT["OBSOLETE"] = "--squirrel-obsolete";
    SQUIRREL_EVENT["UNINSTALL"] = "--squirrel-uninstall";
    SQUIRREL_EVENT["UPDATE"] = "--update";
    SQUIRREL_EVENT["UPDATED"] = "--squirrel-updated";
})(SQUIRREL_EVENT || (SQUIRREL_EVENT = {}));
function spawn(command, args) {
    const commandFile = path.basename(command);
    return new Promise(resolve => {
        const spawnedProcess = childProcess
            .spawn(command, args)
            .on('error', error => logger.error(error))
            .on('close', (code, signal) => {
            if (code !== 0) {
                const exitReason = signal || `exit code ${code}`;
                logger.error(`Running command "${command}" failed: received ${exitReason}`);
            }
            resolve();
        });
        if (spawnedProcess.stdout) {
            spawnedProcess.stdout.on('data', (data) => {
                const stringifiedData = data.toString().trim();
                if (stringifiedData) {
                    logger.info(`${commandFile}: ${stringifiedData}`);
                }
            });
        }
        if (spawnedProcess.stderr) {
            spawnedProcess.stderr.on('data', (data) => {
                const stringifiedData = data.toString().trim();
                if (stringifiedData) {
                    logger.error(`${commandFile}: ${stringifiedData}`);
                }
            });
        }
    });
}
function spawnUpdate(args) {
    return __awaiter(this, void 0, void 0, function* () {
        logger.info('Running updater ...');
        const updateDotExeExists = fs.existsSync(updateDotExe);
        if (!updateDotExeExists) {
            logger.info(`Could not find updater in "${updateDotExe}".`);
        }
        try {
            yield spawn(updateDotExe, args);
        }
        catch (error) {
            logger.error(error);
        }
    });
}
function createShortcut(location) {
    return electron_1.shell.writeShortcutLink(location, 'create', {
        appUserModelId: config_1.config.appUserModelId,
        target: process.execPath,
    });
}
function createShortcuts() {
    logger.info('Creating shortcut in the start menu ...');
    const startResult = createShortcut(startShortcut);
    logger.info('Creating shortcut on the desktop ...');
    const desktopResult = createShortcut(desktopShortcut);
    let quickLaunchResult = false;
    if (quickLaunchShortcut) {
        logger.info('Creating shortcut in the quick launch menu ...');
        quickLaunchResult = createShortcut(desktopShortcut);
    }
    logger.info('Created shortcuts:', { desktop: desktopResult, quickLaunch: quickLaunchResult, start: startResult });
}
function removeShortcuts() {
    return __awaiter(this, void 0, void 0, function* () {
        logger.info('Removing all shortcuts ...');
        yield fs.remove(startShortcut);
        yield fs.remove(desktopShortcut);
        if (quickLaunchShortcut) {
            yield fs.remove(quickLaunchShortcut);
        }
    });
}
function installUpdate() {
    return __awaiter(this, void 0, void 0, function* () {
        logger.info(`Checking for Windows updates at "${EnvironmentUtil.app.UPDATE_URL_WIN}" ...`);
        yield spawnUpdate([SQUIRREL_EVENT.UPDATE, EnvironmentUtil.app.UPDATE_URL_WIN]);
    });
}
exports.installUpdate = installUpdate;
function scheduleUpdate() {
    return __awaiter(this, void 0, void 0, function* () {
        const squirrelDelay = config_1.config.squirrelUpdateInterval.DELAY;
        const squirrelInterval = config_1.config.squirrelUpdateInterval.INTERVAL;
        const nextCheck = squirrelDelay / config_1.MINUTE_IN_MILLIS;
        const regularCheck = squirrelInterval / config_1.HOUR_IN_MILLIS;
        const readableNextCheck = `${nextCheck} ${commons_1.StringUtil.pluralize('minute', nextCheck)}`;
        const readableRegularCheck = `${regularCheck} ${commons_1.StringUtil.pluralize('hour', regularCheck)}`;
        logger.info(`Scheduling Windows update to check in "${readableNextCheck}" and every "${readableRegularCheck}" ...`);
        setTimeout(installUpdate, squirrelDelay);
        setInterval(installUpdate, squirrelInterval);
    });
}
function handleSquirrelArgs() {
    return __awaiter(this, void 0, void 0, function* () {
        const squirrelEvent = process.argv[1];
        switch (squirrelEvent) {
            case SQUIRREL_EVENT.INSTALL: {
                createShortcuts();
                yield lifecycle.quit();
                return;
            }
            case SQUIRREL_EVENT.UPDATED: {
                yield lifecycle.quit();
                return;
            }
            case SQUIRREL_EVENT.UNINSTALL: {
                yield removeShortcuts();
                yield lifecycle.quit();
                return;
            }
            case SQUIRREL_EVENT.OBSOLETE: {
                yield lifecycle.quit();
                return;
            }
        }
        yield scheduleUpdate();
    });
}
exports.handleSquirrelArgs = handleSquirrelArgs;
//# sourceMappingURL=squirrel.js.map