"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
const fs = __importStar(require("fs"));
const path = __importStar(require("path"));
const _1 = require("./");
describe('hostnameShouldBePinned', () => {
    it('pins app.wire.com', () => {
        const result = _1.hostnameShouldBePinned('app.wire.com');
        expect(result).toBe(true);
    });
    it(`doesn't pin localhost`, () => {
        const result = _1.hostnameShouldBePinned('localhost');
        expect(result).toBe(false);
    });
});
describe('getFingerprint', () => {
    it('validates the fingerprint for wire.com', () => {
        const certificatePath = path.join(__dirname, '../spec/helpers/wire.com-wildcard.der');
        const file = fs.readFileSync(certificatePath);
        const fingerprint = _1.getFingerprint(file);
        expect(fingerprint).toBe(_1.WILDCARD_CERT_FINGERPRINT);
    });
});
describe('verifyPinning', () => {
    it('verifies the certificate for wire.com', () => {
        const certificatePath = path.join(__dirname, '../spec/helpers/wire.com-wildcard.der');
        const issuerCertPath = path.join(__dirname, '../spec/helpers/wire.com-issuer.der');
        const certFile = fs.readFileSync(certificatePath);
        const issuerCertFile = fs.readFileSync(issuerCertPath);
        const certData = {
            data: _1.buildCert(certFile),
            issuerCert: {
                data: _1.buildCert(issuerCertFile),
            },
        };
        const pinningResult = _1.verifyPinning('wire.com', certData);
        expect(pinningResult.verifiedPublicKeyInfo).toBe(true);
        expect(pinningResult.errorMessage).toBeUndefined();
    });
    it('checks for the correct root certificate', () => {
        const certificatePath = path.join(__dirname, '../spec/helpers/VeriSign-Class-3-Public-Primary-Certification-Authority-G5.pem');
        const certFile = fs.readFileSync(certificatePath, 'utf-8');
        const certData = {
            data: certFile,
            issuerCert: { data: certFile },
        };
        const pinningResult = _1.verifyPinning('58gewxuxp0gp84o4zi8vppxz8.cloudfront.net', certData);
        expect(pinningResult.verifiedIssuerRootCerts).toBe(true);
        expect(pinningResult.errorMessage).toBeUndefined();
    });
    it('checks for wrong root certificates', () => {
        const wrongCertificatePath = path.join(__dirname, '../spec/helpers/VeriSign-Class-3-Public-Primary-Certification-Authority-G4.pem');
        const wrongCertFile = fs.readFileSync(wrongCertificatePath, 'utf-8');
        const certData = {
            data: wrongCertFile,
            issuerCert: { data: wrongCertFile },
        };
        const pinningResult = _1.verifyPinning('58gewxuxp0gp84o4zi8vppxz8.cloudfront.net', certData);
        expect(pinningResult.verifiedIssuerRootCerts).toBe(false);
        expect(pinningResult.errorMessage).toMatch(/none of .* could be verified/);
    });
    it('checks for broken root certificates', () => {
        const brokenCertificatePath = path.join(__dirname, '../spec/helpers/VeriSign-Class-3-Public-Primary-Certification-Authority-G5-BROKEN.pem');
        const brokenCertFile = fs.readFileSync(brokenCertificatePath, 'utf-8');
        const certData = {
            data: brokenCertFile,
            issuerCert: { data: brokenCertFile },
        };
        const pinningResult = _1.verifyPinning('58gewxuxp0gp84o4zi8vppxz8.cloudfront.net', certData);
        expect(pinningResult.verifiedIssuerRootCerts).toBe(false);
        expect(pinningResult.errorMessage).toMatch(/none of .* could be verified/);
    });
});
//# sourceMappingURL=CertUtil.test.js.map