"use strict";
/*
 * Wire
 * Copyright (C) 2018 Wire Swiss GmbH
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see http://www.gnu.org/licenses/.
 *
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.DEPRECATED_getById = exports.DEPRECATED_ACCENT_COLORS = exports.getRandom = exports.getById = exports.ACCENT_COLORS = exports.VIOLET = exports.SOFT_PINK = exports.BRIGHT_ORANGE = exports.VIVID_RED = exports.DEPRECATED_YELLOW = exports.STRONG_LIME_GREEN = exports.STRONG_BLUE = exports.AccentColorID = void 0;
const RandomUtil = __importStar(require("./RandomUtil"));
var AccentColorID;
(function (AccentColorID) {
    AccentColorID[AccentColorID["BRIGHT_ORANGE"] = 5] = "BRIGHT_ORANGE";
    AccentColorID[AccentColorID["SOFT_PINK"] = 6] = "SOFT_PINK";
    AccentColorID[AccentColorID["STRONG_BLUE"] = 1] = "STRONG_BLUE";
    AccentColorID[AccentColorID["STRONG_LIME_GREEN"] = 2] = "STRONG_LIME_GREEN";
    AccentColorID[AccentColorID["VIOLET"] = 7] = "VIOLET";
    AccentColorID[AccentColorID["VIVID_RED"] = 4] = "VIVID_RED";
    /** @deprecated */
    AccentColorID[AccentColorID["YELLOW"] = 3] = "YELLOW";
})(AccentColorID = exports.AccentColorID || (exports.AccentColorID = {}));
exports.STRONG_BLUE = {
    color: '#2391d3',
    id: AccentColorID.STRONG_BLUE,
    name: 'StrongBlue',
};
exports.STRONG_LIME_GREEN = {
    color: '#00c800',
    id: AccentColorID.STRONG_LIME_GREEN,
    name: 'StrongLimeGreen',
};
exports.DEPRECATED_YELLOW = {
    color: '#febf02',
    id: AccentColorID.YELLOW,
    name: 'Yellow',
};
exports.VIVID_RED = {
    color: '#fb0807',
    id: AccentColorID.VIVID_RED,
    name: 'VividRed',
};
exports.BRIGHT_ORANGE = {
    color: '#ff8900',
    id: AccentColorID.BRIGHT_ORANGE,
    name: 'BrightOrange',
};
exports.SOFT_PINK = {
    color: '#fe5ebd',
    id: AccentColorID.SOFT_PINK,
    name: 'SoftPink',
};
exports.VIOLET = {
    color: '#9c00fe',
    id: AccentColorID.VIOLET,
    name: 'Violet',
};
exports.ACCENT_COLORS = [
    exports.BRIGHT_ORANGE,
    exports.SOFT_PINK,
    exports.STRONG_BLUE,
    exports.STRONG_LIME_GREEN,
    exports.VIOLET,
    exports.VIVID_RED,
];
const getById = (id) => exports.ACCENT_COLORS.find(color => color.id === id);
exports.getById = getById;
const getRandom = () => RandomUtil.randomArrayElement(exports.ACCENT_COLORS);
exports.getRandom = getRandom;
/**
 * Use with caution:
 * This only exists to support deprecated color schemes and
 * is only permitted for usage in a read only manner.
 */
exports.DEPRECATED_ACCENT_COLORS = [
    exports.BRIGHT_ORANGE,
    exports.DEPRECATED_YELLOW,
    exports.SOFT_PINK,
    exports.STRONG_BLUE,
    exports.STRONG_LIME_GREEN,
    exports.VIOLET,
    exports.VIVID_RED,
];
/**
 * Use with caution:
 * This only exists to support deprecated color schemes and
 * is only permitted for usage in a read only manner.
 *
 * @param id AccentColor ID
 * @returns AccentColor with given ID | undefined
 */
const DEPRECATED_getById = (id) => exports.DEPRECATED_ACCENT_COLORS.find(color => color.id === id);
exports.DEPRECATED_getById = DEPRECATED_getById;
//# sourceMappingURL=AccentColor.js.map