"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.filterButtonProps = exports.Button = exports.buttonStyle = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

var _Misc = require("../Misc");

var _Text = require("../Text");

var _util = require("../util");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var buttonStyle = function buttonStyle(theme, _ref) {
  var _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? _Identity.COLOR.BLUE : _ref$backgroundColor,
      _ref$block = _ref.block,
      block = _ref$block === void 0 ? false : _ref$block,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$noCapital = _ref.noCapital,
      noCapital = _ref$noCapital === void 0 ? false : _ref$noCapital,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? true : _ref$bold,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? true : _ref$center,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? _Identity.COLOR.WHITE : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '16px' : _ref$fontSize,
      _ref$noWrap = _ref.noWrap,
      noWrap = _ref$noWrap === void 0 ? true : _ref$noWrap,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? true : _ref$truncate,
      props = _objectWithoutProperties(_ref, ["backgroundColor", "block", "disabled", "noCapital", "bold", "center", "color", "fontSize", "noWrap", "textTransform", "truncate"]);

  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    bold: bold,
    center: center,
    color: color,
    disabled: disabled,
    fontSize: fontSize,
    noWrap: noWrap,
    textTransform: textTransform,
    truncate: truncate
  }, props))), {}, {
    '&:hover, &:focus': {
      backgroundColor: disabled ? backgroundColor : _Identity.COLOR.shade(backgroundColor, 0.06),
      textDecoration: 'none'
    },
    backgroundColor: backgroundColor,
    border: 0,
    borderRadius: '8px',
    cursor: disabled ? 'default' : 'pointer',
    display: 'inline-block',
    height: '48px',
    lineHeight: '48px',
    marginBottom: '16px',
    maxWidth: '100%',
    minWidth: '150px',
    opacity: disabled ? 0.56 : 1,
    outline: 'none',
    padding: '0 32px',
    textDecoration: 'none',
    touchAction: 'manipulation',
    transition: _motions.defaultTransition,
    width: block ? '100%' : 'auto'
  });
};

exports.buttonStyle = buttonStyle;

var Button = function Button(_ref2) {
  var showLoading = _ref2.showLoading,
      children = _ref2.children,
      _ref2$loadingColor = _ref2.loadingColor,
      loadingColor = _ref2$loadingColor === void 0 ? _Identity.COLOR.WHITE : _ref2$loadingColor,
      props = _objectWithoutProperties(_ref2, ["showLoading", "children", "loadingColor"]);

  return (0, _core.jsx)("button", _extends({
    css: function css(theme) {
      return buttonStyle(theme, props);
    }
  }, filterButtonProps(props)), showLoading ? (0, _core.jsx)(_Misc.Loading, {
    size: 30,
    color: loadingColor,
    style: {
      display: 'flex',
      margin: 'auto'
    }
  }) : children);
};

exports.Button = Button;

var filterButtonProps = function filterButtonProps(props) {
  return (0, _util.filterProps)((0, _Text.filterTextProps)(props), ['backgroundColor', 'noCapital']);
};

exports.filterButtonProps = filterButtonProps;
//# sourceMappingURL=Button.js.map