"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CheckboxLabel = exports.Checkbox = void 0;

var _core = require("@emotion/core");

var _react = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _Text = require("../Text");

var _util = require("../util");

var _Input = require("./Input");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var filterStyledLabelProps = function filterStyledLabelProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid']);
};

var StyledLabel = function StyledLabel(props) {
  var checkSvg = '<svg xmlns="http://www.w3.org/2000/svg" width="8" height="6" viewBox="0 0 8 6"><path fill="white" d="M2.8 6L8 .7 7.3 0 2.8 4.6.7 2.4l-.7.7z"/></svg>';
  return (0, _core.jsx)("label", _extends({
    css: function css(theme) {
      var _ref;

      return _ref = {}, _defineProperty(_ref, ".".concat(_Input.INPUT_CLASSNAME, ":checked + &::before"), {
        background: "".concat(_Identity.COLOR.BLUE, " url('data:image/svg+xml; utf8, ").concat(checkSvg, "') no-repeat center")
      }), _defineProperty(_ref, ".".concat(_Input.INPUT_CLASSNAME, ":focus + &::before"), {
        borderColor: _Identity.COLOR.BLUE
      }), _defineProperty(_ref, '&::before', {
        background: _Identity.COLOR.WHITE,
        border: props.markInvalid ? "1px solid ".concat(_Identity.COLOR.RED) : "1px solid ".concat(_Identity.COLOR.GRAY),
        borderRadius: '4px',
        boxSizing: 'border-box',
        content: '""',
        display: 'inline-block',
        height: '16px',
        margin: '4px 8px 0 -16px',
        opacity: props.disabled ? 0.56 : 1,
        width: '16px'
      }), _defineProperty(_ref, "a", _objectSpread({}, (0, _Text.textLinkStyle)(theme, {}))), _defineProperty(_ref, "display", 'flex'), _defineProperty(_ref, "opacity", props.disabled ? 0.56 : 1), _ref;
    }
  }, filterStyledLabelProps(props)));
};

var filterCheckboxProps = function filterCheckboxProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid']);
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "ofijmy-Checkbox",
  styles: "align-items:center;display:flex;justify-content:flex-start;;label:Checkbox;"
} : {
  name: "ofijmy-Checkbox",
  styles: "align-items:center;display:flex;justify-content:flex-start;;label:Checkbox;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var Checkbox = /*#__PURE__*/_react["default"].forwardRef(function (_ref2, ref) {
  var _ref2$id = _ref2.id,
      id = _ref2$id === void 0 ? Math.random().toString() : _ref2$id,
      children = _ref2.children,
      style = _ref2.style,
      disabled = _ref2.disabled,
      props = _objectWithoutProperties(_ref2, ["id", "children", "style", "disabled"]);

  return (0, _core.jsx)("div", {
    css: _ref3,
    style: style
  }, (0, _core.jsx)(_Input.Input, _extends({
    type: 'checkbox',
    id: id,
    style: {
      height: '16px',
      marginBottom: '0',
      opacity: 0,
      width: '16px'
    },
    disabled: disabled,
    ref: ref
  }, filterCheckboxProps(props))), (0, _core.jsx)(StyledLabel, {
    htmlFor: id,
    disabled: disabled,
    markInvalid: props.markInvalid
  }, children));
});

exports.Checkbox = Checkbox;

var CheckboxLabel = function CheckboxLabel(_ref4) {
  var _ref4$color = _ref4.color,
      color = _ref4$color === void 0 ? _Identity.COLOR.TEXT : _ref4$color,
      props = _objectWithoutProperties(_ref4, ["color"]);

  return (0, _core.jsx)(_Text.Text, _extends({
    css: function css(theme) {
      return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
        color: color
      }, props))), {}, {
        a: {
          color: _Identity.COLOR.LINK,
          textDecoration: 'none'
        }
      });
    }
  }, props));
};

exports.CheckboxLabel = CheckboxLabel;
//# sourceMappingURL=Checkbox.js.map