"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CodeInput = void 0;

var _core = require("@emotion/core");

var _react = _interopRequireWildcard(require("react"));

var _util = require("../util");

var _Input = require("./Input");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

var _ref = process.env.NODE_ENV === "production" ? {
  name: "140dmuy-CodeInputWrapper",
  styles: "display:flex;justify-content:center;;label:CodeInputWrapper;"
} : {
  name: "140dmuy-CodeInputWrapper",
  styles: "display:flex;justify-content:center;;label:CodeInputWrapper;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var CodeInputWrapper = function CodeInputWrapper(props) {
  return (0, _core.jsx)("div", _extends({
    css: _ref
  }, props));
};

var digitInputStyle = function digitInputStyle(theme, props) {
  return _objectSpread(_objectSpread({}, (0, _Input.inputStyle)(theme, props)), {}, {
    '& + &': {
      marginLeft: '19px'
    },
    fontSize: '32px',
    lineHeight: '56px',
    padding: 0,
    textAlign: 'center',
    width: '48px'
  });
};

var DigitInput = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)("input", _extends({
    ref: ref,
    css: function css(theme) {
      return digitInputStyle(theme, props);
    }
  }, props));
});

var CodeInput = function CodeInput(_ref2) {
  var style = _ref2.style,
      _ref2$digits = _ref2.digits,
      digits = _ref2$digits === void 0 ? 6 : _ref2$digits,
      _ref2$autoFocus = _ref2.autoFocus,
      autoFocus = _ref2$autoFocus === void 0 ? false : _ref2$autoFocus,
      markInvalid = _ref2.markInvalid,
      _ref2$onCodeComplete = _ref2.onCodeComplete,
      onCodeComplete = _ref2$onCodeComplete === void 0 ? _util.noop : _ref2$onCodeComplete,
      disabled = _ref2.disabled;

  var _useState = (0, _react.useState)(Array(digits).fill('')),
      _useState2 = _slicedToArray(_useState, 2),
      values = _useState2[0],
      setValues = _useState2[1];

  var inputs = Array(digits);

  var forceSelection = function forceSelection(event) {
    var target = event.target;
    target.select();
  };

  var forceSelectionPreventDefault = function forceSelectionPreventDefault(event) {
    forceSelection(event);
    event.preventDefault();
  };

  var nextField = function nextField(currentFieldIndex) {
    var nextFieldIndex = currentFieldIndex + 1;

    if (nextFieldIndex < digits) {
      inputs[nextFieldIndex].focus();
    }
  };

  var previousField = function previousField(currentFieldIndex) {
    if (currentFieldIndex > 0) {
      inputs[currentFieldIndex - 1].focus();
    }
  };

  var setValue = function setValue(fieldIndex, value) {
    if (/^[0-9]?$/.test(value)) {
      var valuesCopy = values.slice();
      valuesCopy[fieldIndex] = value;
      setValues(valuesCopy);

      if (value.length) {
        nextField(fieldIndex);
      }
    }
  };

  var handleKeyDown = function handleKeyDown(fieldIndex, _ref3) {
    var key = _ref3.key;

    switch (key) {
      case 'Backspace':
        setValue(fieldIndex, '');
        previousField(fieldIndex);
        break;

      case 'ArrowLeft':
        previousField(fieldIndex);
        break;

      case 'ArrowRight':
        nextField(fieldIndex);
        break;
    }

    if (/^[0-9]$/.test(key)) {
      setValue(fieldIndex, key);
    }
  };

  var handlePaste = function handlePaste(fieldIndex, event) {
    var pastedValue = event.clipboardData.getData('Text');
    var cleanedPaste = pastedValue.replace(/[^0-9]/g, '');

    if (/^[0-9]+$/.test(cleanedPaste)) {
      setValues(values.slice(0, fieldIndex).concat(cleanedPaste.split('')).slice(0, digits));
    }
  };

  (0, _react.useEffect)(function () {
    var completeCode = values.join('');

    if (completeCode.length === digits) {
      onCodeComplete(completeCode);
    }
  }, [values]);
  return (0, _core.jsx)(CodeInputWrapper, {
    style: style
  }, Array.from({
    length: digits
  }, function (_, index) {
    return (0, _core.jsx)(DigitInput, {
      autoFocus: index === 0 && autoFocus,
      key: index,
      onPaste: function onPaste(event) {
        return handlePaste(index, event);
      },
      onFocus: forceSelection,
      onMouseDown: forceSelectionPreventDefault,
      onTouchStart: forceSelectionPreventDefault,
      onKeyDown: function onKeyDown(event) {
        return handleKeyDown(index, event);
      },
      onKeyUp: forceSelection,
      markInvalid: markInvalid,
      ref: function ref(node) {
        return inputs[index] = node;
      },
      type: "text",
      value: values[index],
      onChange: function onChange() {},
      disabled: disabled
    });
  }));
};

exports.CodeInput = CodeInput;
//# sourceMappingURL=CodeInput.js.map