"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ErrorMessage = exports.errorMessageStyle = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _Text = require("../Text");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var errorMessageStyle = function errorMessageStyle(theme, _ref) {
  var _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? false : _ref$bold,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? true : _ref$center,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? _Identity.COLOR.RED : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '11px' : _ref$fontSize,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      props = _objectWithoutProperties(_ref, ["bold", "center", "color", "fontSize", "textTransform"]);

  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    bold: bold,
    center: center,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props))), {}, {
    a: _objectSpread({}, (0, _Text.linkStyle)(theme, {
      bold: bold,
      fontSize: fontSize,
      textTransform: textTransform
    })),
    display: 'block',
    marginBottom: '12px'
  });
};

exports.errorMessageStyle = errorMessageStyle;

var ErrorMessage = function ErrorMessage(props) {
  return (0, _core.jsx)(_Text.Text, _extends({
    css: function css(theme) {
      return errorMessageStyle(theme, props);
    }
  }, props));
};

exports.ErrorMessage = ErrorMessage;
//# sourceMappingURL=ErrorMessage.js.map