"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RoundIconButton = exports.roundIconButtonStyle = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _Misc = require("../Misc/");

var _Button = require("./Button");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var roundIconButtonStyle = function roundIconButtonStyle(theme, props) {
  return _objectSpread(_objectSpread({}, (0, _Button.buttonStyle)(theme, props)), {}, {
    alignItems: 'center',
    borderRadius: '50%',
    display: 'flex',
    height: "".concat(props.size, "px"),
    justifyContent: 'center',
    lineHeight: 'initial',
    margin: '0 auto',
    minWidth: "".concat(props.size, "px"),
    padding: 0,
    width: "".concat(props.size, "px")
  });
};

exports.roundIconButtonStyle = roundIconButtonStyle;

var RoundIconButton = function RoundIconButton(_ref) {
  var children = _ref.children,
      props = _objectWithoutProperties(_ref, ["children"]);

  return (0, _core.jsx)("button", _extends({
    css: function css(theme) {
      return roundIconButtonStyle(theme, props);
    }
  }, (0, _Button.filterButtonProps)(props)), (0, _Misc.childrenWithDefaultProps)({
    children: children,
    defaultProps: {
      color: _Identity.COLOR.WHITE
    }
  }));
};

exports.RoundIconButton = RoundIconButton;
RoundIconButton.defaultProps = {
  backgroundColor: _Identity.COLOR.BLUE,
  size: 32
};
//# sourceMappingURL=RoundIconButton.js.map