"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Select = exports.selectStyle = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _util = require("../util");

var _Input = require("./Input");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var ArrowDown = function ArrowDown(theme) {
  return "\n  <svg xmlns=\"http://www.w3.org/2000/svg\" width=\"8\" height=\"8\" viewBox=\"0 0 8 8\">\n    <path fill=\"".concat(theme.general.color, "\" fillRule=\"evenodd\" d=\"M0 2h8L4 7\" />\n  </svg>\n");
};

var selectStyle = function selectStyle(theme, _ref) {
  var _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      markInvalid = _ref.markInvalid,
      props = _objectWithoutProperties(_ref, ["disabled", "markInvalid"]);

  return _objectSpread(_objectSpread({}, (0, _Input.inputStyle)(theme, props)), {}, {
    '&:-moz-focusring': {
      color: 'transparent',
      textShadow: '0 0 0 #000'
    },
    '&:disabled': {
      color: _Identity.COLOR.GRAY
    },
    appearance: 'none',
    background: disabled ? theme.Input.backgroundColorDisabled : "".concat(theme.Input.backgroundColor, " center right 16px no-repeat url(\"").concat((0, _util.inlineSVG)(ArrowDown(theme)), "\")"),
    boxShadow: markInvalid ? "0 0 0 1px ".concat(_Identity.COLOR.RED) : "0 0 0 1px ".concat(_Identity.COLOR.GRAY),
    cursor: disabled ? 'normal' : 'pointer',
    fontSize: '16px',
    fontWeight: 300,
    paddingRight: '30px'
  });
};

exports.selectStyle = selectStyle;

var filterSelectProps = function filterSelectProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid']);
};

var Select = function Select(props) {
  return (0, _core.jsx)("select", _extends({
    css: function css(theme) {
      return selectStyle(theme, props);
    }
  }, filterSelectProps(props)));
};

exports.Select = Select;
//# sourceMappingURL=Select.js.map