"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ShakeBox = void 0;

var _css2 = _interopRequireDefault(require("@emotion/css"));

var _core = require("@emotion/core");

var _react = _interopRequireWildcard(require("react"));

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var ShakeBox = /*#__PURE__*/_react["default"].forwardRef(function (_ref, ref) {
  var children = _ref.children,
      _ref$amplitude = _ref.amplitude,
      amplitude = _ref$amplitude === void 0 ? 8 : _ref$amplitude,
      _ref$damping = _ref.damping,
      damping = _ref$damping === void 0 ? 0.75 : _ref$damping,
      _ref$speed = _ref.speed,
      speed = _ref$speed === void 0 ? 4 : _ref$speed,
      _ref$threshold = _ref.threshold,
      threshold = _ref$threshold === void 0 ? 1 : _ref$threshold;

  var _useState = (0, _react.useState)(0),
      _useState2 = _slicedToArray(_useState, 2),
      offset = _useState2[0],
      setOffset = _useState2[1];

  var requestAnimationId = 0;

  var shakeLoop = function shakeLoop(targetOffset) {
    var currentOffset = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0;

    if (targetOffset > 0 && currentOffset < targetOffset) {
      currentOffset += speed;
    } else if (targetOffset < 0 && currentOffset > targetOffset) {
      currentOffset -= speed;
    } else {
      currentOffset = targetOffset - (currentOffset - targetOffset);
      targetOffset *= -damping;
    }

    if (Math.abs(targetOffset) >= threshold) {
      requestAnimationId = requestAnimationFrame(function () {
        return shakeLoop(targetOffset, currentOffset);
      });
    } else {
      currentOffset = 0;
    }

    setOffset(currentOffset);
  };

  (0, _react.useImperativeHandle)(ref, function () {
    return {
      shake: function shake() {
        cancelAnimationFrame(requestAnimationId);
        shakeLoop(amplitude);
      }
    };
  });
  (0, _react.useEffect)(function () {
    return function () {
      return cancelAnimationFrame(requestAnimationId);
    };
  }, []);
  return (0, _core.jsx)("div", {
    css: /*#__PURE__*/(0, _css2["default"])({
      transform: "translateX(".concat(offset, "px)")
    }, ";label:ShakeBox;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"))
  }, children);
});

exports.ShakeBox = ShakeBox;
//# sourceMappingURL=ShakeBox.js.map