"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextArea = exports.TEXTAREA_CLASSNAME = exports.textAreaStyle = void 0;

var _core = require("@emotion/core");

var _react = _interopRequireDefault(require("react"));

var _Identity = require("../Identity");

var _util = require("../util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var textAreaStyle = function textAreaStyle(theme, _ref) {
  var _ref$markInvalid = _ref.markInvalid,
      markInvalid = _ref$markInvalid === void 0 ? false : _ref$markInvalid,
      _ref$placeholderTextT = _ref.placeholderTextTransform,
      placeholderTextTransform = _ref$placeholderTextT === void 0 ? 'none' : _ref$placeholderTextT,
      _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled;
  var placeholderStyle = {
    color: theme.Input.placeholderColor,
    fontSize: '11px',
    textTransform: placeholderTextTransform
  };
  return {
    '&::-moz-placeholder': _objectSpread(_objectSpread({}, placeholderStyle), {}, {
      opacity: 1
    }),
    '&::-ms-input-placeholder': _objectSpread({}, placeholderStyle),
    '&::-webkit-input-placeholder': _objectSpread({}, placeholderStyle),
    '&:focus': {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR.BLUE)
    },
    '&:invalid': !markInvalid ? {
      boxShadow: "0 0 0 1px ".concat(_Identity.COLOR.GRAY)
    } : {},
    background: disabled ? theme.Input.backgroundColorDisabled : theme.Input.backgroundColor,
    border: 'none',
    borderRadius: '4px',
    boxShadow: markInvalid ? "0 0 0 1px ".concat(_Identity.COLOR.RED) : "0 0 0 1px ".concat(_Identity.COLOR.GRAY),
    caretColor: _Identity.COLOR.BLUE,
    color: theme.general.color,
    fontWeight: 300,
    lineHeight: '24px',
    margin: '0 0 16px',
    outline: 'none',
    padding: '16px 16px',
    resize: 'none',
    width: '100%'
  };
};

exports.textAreaStyle = textAreaStyle;
var TEXTAREA_CLASSNAME = 'textarea';
exports.TEXTAREA_CLASSNAME = TEXTAREA_CLASSNAME;

var filterTextAreaProps = function filterTextAreaProps(props) {
  return (0, _util.filterProps)(props, ['markInvalid', 'placeholderTextTransform']);
};

var TextArea = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)("textarea", _extends({
    className: TEXTAREA_CLASSNAME,
    css: function css(theme) {
      return textAreaStyle(theme, props);
    },
    ref: ref
  }, filterTextAreaProps(props)));
});

exports.TextArea = TextArea;
//# sourceMappingURL=TextArea.js.map