"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Tooltip = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _util = require("../util");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var tooltipStyle = function tooltipStyle(_ref) {
  var _ref$disabled = _ref.disabled,
      disabled = _ref$disabled === void 0 ? false : _ref$disabled,
      _ref$bottom = _ref.bottom,
      bottom = _ref$bottom === void 0 ? false : _ref$bottom,
      _ref$left = _ref.left,
      left = _ref$left === void 0 ? false : _ref$left,
      _ref$right = _ref.right,
      right = _ref$right === void 0 ? false : _ref$right,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light;
  return {
    '&::after': {
      backgroundColor: light ? _Identity.COLOR.WHITE : _Identity.COLOR.TEXT,
      borderRadius: '4px',
      bottom: bottom || left || right ? 'auto' : 'calc(100% + 8px)',
      boxShadow: '0 2px 16px 0 rgba(0, 0, 0, 0.12)',
      color: light ? _Identity.COLOR.TEXT : _Identity.COLOR.WHITE,
      content: 'attr(data-text)',
      display: 'block',
      fontSize: '12px',
      fontWeight: light ? 400 : 600,
      left: right ? 'calc(100% + 8px)' : 'auto',
      lineHeight: '14px',
      maxWidth: '200px',
      minWidth: '120px',
      opacity: 0,
      padding: '12px',
      pointerEvents: 'none',
      position: 'absolute',
      right: left ? 'calc(100% + 8px)' : 'auto',
      textAlign: 'center',
      top: bottom ? 'calc(100% + 8px)' : 'auto',
      transform: left || right ? "translateX(".concat(left ? -16 : 16, "px)") : "translateY(".concat(bottom ? -16 : 16, "px)"),
      transition: 'all 0.15s ease-in-out'
    },
    '&:hover::after': disabled || {
      opacity: 1,
      transform: 'translateY(0) translateX(0)',
      transition: 'all 0.25s ease-in-out'
    },
    alignItems: 'center',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    position: 'relative'
  };
};

var filterTooltipProps = function filterTooltipProps(props) {
  return (0, _util.filterProps)(props, ['bottom', 'disabled', 'left', 'light', 'right']);
};

var Tooltip = function Tooltip(_ref2) {
  var _ref2$text = _ref2.text,
      text = _ref2$text === void 0 ? '' : _ref2$text,
      props = _objectWithoutProperties(_ref2, ["text"]);

  return (0, _core.jsx)("div", _extends({
    css: tooltipStyle(props),
    "data-text": text
  }, filterTooltipProps(props)));
};

exports.Tooltip = Tooltip;
//# sourceMappingURL=Tooltip.js.map