"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.GlobalStyle = void 0;

var _core = require("@emotion/core");

var _emotionNormalize = _interopRequireDefault(require("emotion-normalize"));

var _emotionTheming = require("emotion-theming");

var _TextLink = require("./Text/TextLink");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var globalStyles = function globalStyles(theme) {
  return {
    '*': {
      boxSizing: 'border-box'
    },
    a: _objectSpread({}, (0, _TextLink.textLinkStyle)(theme, {})),
    'b, strong': {
      fontWeight: 600
    },
    body: {
      MozOsxFontSmoothing: 'grayscale',
      WebkitFontSmoothing: 'antialiased',
      background: theme.general.backgroundColor,
      color: theme.general.color,
      display: 'flex',
      flexDirection: 'column',
      fontFamily: '-apple-system, BlinkMacSystemFont, Segoe UI, Roboto, Helvetica Neue, Helvetica, Arial, sans-serif',
      fontWeight: 300,
      lineHeight: 1.5,
      minHeight: '100vh',
      transition: 'background 0.15s'
    },
    html: {
      background: theme.general.backgroundColor,
      transition: 'background 0.15s'
    },
    p: {
      marginTop: 0
    }
  };
};

var globalStyle = function globalStyle(theme) {
  return /*#__PURE__*/(0, _core.css)(_emotionNormalize["default"], " ", globalStyles(theme), process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */");
};

var GlobalStyle = (0, _emotionTheming.withTheme)(function (_ref) {
  var theme = _ref.theme;
  return (0, _core.jsx)(_core.Global, {
    styles: globalStyle(theme)
  });
});
exports.GlobalStyle = GlobalStyle;
//# sourceMappingURL=GlobalStyle.js.map