"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SVGIcon = void 0;

var _core = require("@emotion/core");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var svgIconStyle = function svgIconStyle(theme, _ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color;
  return {
    fill: color,
    overflow: 'visible'
  };
};

var SVGIcon = function SVGIcon(_ref2) {
  var realWidth = _ref2.realWidth,
      realHeight = _ref2.realHeight,
      _ref2$scale = _ref2.scale,
      scale = _ref2$scale === void 0 ? 1 : _ref2$scale,
      _ref2$width = _ref2.width,
      width = _ref2$width === void 0 ? null : _ref2$width,
      _ref2$height = _ref2.height,
      height = _ref2$height === void 0 ? null : _ref2$height,
      shadow = _ref2.shadow,
      children = _ref2.children,
      props = _objectWithoutProperties(_ref2, ["realWidth", "realHeight", "scale", "width", "height", "shadow", "children"]);

  var newScale = scale;

  if (width || height) {
    var widthScale = width ? width / realWidth : Infinity;
    var heightScale = height ? height / realHeight : Infinity;
    newScale = Math.min(widthScale, heightScale);
  }

  var newWidth = Math.ceil(realWidth * newScale);
  var newHeight = Math.ceil(realHeight * newScale);
  var shadowId = shadow && Math.random().toString();
  return (0, _core.jsx)("svg", _extends({
    css: function css(theme) {
      return svgIconStyle(theme, props);
    },
    viewBox: "0 0 ".concat(realWidth, " ").concat(realHeight),
    width: newWidth,
    height: newHeight
  }, props), shadow && (0, _core.jsx)("defs", null, (0, _core.jsx)("filter", {
    id: shadowId,
    x: "-50%",
    y: "-50%",
    width: "200%",
    height: "200%"
  }, (0, _core.jsx)("feOffset", {
    result: "offOut",
    "in": "SourceAlpha",
    dx: "0",
    dy: "0"
  }), (0, _core.jsx)("feGaussianBlur", {
    result: "blurOut",
    "in": "offOut",
    stdDeviation: "2.5"
  }), (0, _core.jsx)("feBlend", {
    "in": "SourceGraphic",
    in2: "blurOut",
    mode: "normal"
  }))), (0, _core.jsx)("g", {
    filter: shadow && "url(#".concat(shadowId, ")")
  }, children));
};

exports.SVGIcon = SVGIcon;
//# sourceMappingURL=SVGIcon.js.map