"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Avatar = exports.DEFAULT_AVATAR_SIZE = void 0;

var _css2 = _interopRequireDefault(require("@emotion/css"));

var _core = require("@emotion/core");

var _react = require("react");

var _Misc = require("../Misc/");

var _util = require("../util");

var _colors = require("./colors");

var _motions = require("./motions");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var DEFAULT_AVATAR_SIZE = 28;
exports.DEFAULT_AVATAR_SIZE = DEFAULT_AVATAR_SIZE;

var avatarStyle = function avatarStyle(_ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? _colors.COLOR.WHITE : _ref$color,
      base64Image = _ref.base64Image,
      borderColor = _ref.borderColor,
      _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? _colors.COLOR.GRAY : _ref$backgroundColor,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? DEFAULT_AVATAR_SIZE : _ref$size,
      isAvatarGridItem = _ref.isAvatarGridItem;
  var BORDER_SIZE_LIMIT = 32;
  var borderSize = size > BORDER_SIZE_LIMIT ? 2 : 1;
  var borderWidth = base64Image ? 0 : borderSize;
  var fontSize = "".concat(Math.ceil(size / 2.2), "px");
  return {
    alignItems: 'center',
    backgroundColor: backgroundColor,
    borderRadius: isAvatarGridItem ? '0' : '50%',
    boxShadow: isAvatarGridItem ? 'none' : "inset 0 0 0 ".concat(borderWidth, "px ").concat(borderColor),
    color: color,
    display: 'flex',
    fontSize: fontSize,
    fontWeight: isAvatarGridItem ? 700 : 300,
    height: "".concat(size, "px"),
    justifyContent: 'center',
    minHeight: "".concat(size, "px"),
    minWidth: "".concat(size, "px"),
    overflow: 'hidden',
    width: "".concat(size, "px")
  };
};

var filteredAvatarProps = function filteredAvatarProps(props) {
  return (0, _util.filterProps)(props, ['size', 'forceInitials', 'name', 'base64Image', 'borderColor', 'backgroundColor', 'fetchImage', 'isAvatarGridItem']);
};

var Avatar = function Avatar(props) {
  var base64Image = props.base64Image,
      forceInitials = props.forceInitials,
      name = props.name,
      fetchImage = props.fetchImage,
      isAvatarGridItem = props.isAvatarGridItem;

  var _useState = (0, _react.useState)(0),
      _useState2 = _slicedToArray(_useState, 2),
      scale = _useState2[0],
      setScale = _useState2[1];

  (0, _react.useEffect)(function () {
    if (base64Image) {
      requestAnimationFrame(function () {
        return setScale(1);
      });
    }
  }, [base64Image]);

  var getInitials = function getInitials() {
    var name = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : '';
    return name.split(' ').map(function (_ref2) {
      var _ref3 = _slicedToArray(_ref2, 1),
          initial = _ref3[0];

      return initial && initial.toUpperCase();
    }).join('').substring(0, isAvatarGridItem ? 1 : 2);
  };

  return (0, _core.jsx)(_Misc.IsInViewport, _extends({
    checkViewportOnce: true,
    onEnterViewport: fetchImage,
    disabled: !!base64Image,
    css: avatarStyle(props),
    "data-uie-name": !forceInitials && base64Image ? 'element-avatar-image' : 'element-avatar-initials'
  }, filteredAvatarProps(props)), forceInitials || !base64Image ? getInitials(name) : (0, _core.jsx)("div", {
    css: /*#__PURE__*/(0, _css2["default"])({
      backgroundImage: base64Image && "url(data:image/png;base64,".concat(base64Image, ")"),
      backgroundPosition: 'center',
      backgroundSize: 'cover',
      borderRadius: isAvatarGridItem ? '0' : '50%',
      minHeight: '100%',
      minWidth: '100%',
      opacity: scale,
      transform: "scale(".concat(scale, ")"),
      transition: "all ".concat(_motions.DURATION.DEFAULT, "ms ").concat(_motions.EASE.QUART),
      width: '100%'
    }, ";label:Avatar;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"))
  }));
};

exports.Avatar = Avatar;
//# sourceMappingURL=Avatar.js.map