"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AvatarGrid = void 0;

var _css2 = _interopRequireDefault(require("@emotion/css"));

var _core = require("@emotion/core");

var _Misc = require("../Misc/");

var _util = require("../util");

var _Avatar = require("./Avatar");

var _colors = require("./colors");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var avatarGridStyle = function avatarGridStyle(_ref) {
  var borderWidth = _ref.borderWidth,
      size = _ref.size,
      _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? _colors.COLOR.GRAY_DARKEN_48 : _ref$backgroundColor,
      _ref$borderColor = _ref.borderColor,
      borderColor = _ref$borderColor === void 0 ? _colors.COLOR.GRAY_DARKEN_48 : _ref$borderColor;
  return {
    alignItems: 'start',
    backgroundColor: backgroundColor,
    border: "".concat(borderWidth, "px solid ").concat(borderColor),
    borderRadius: '16%',
    display: 'grid',
    gridGap: borderWidth,
    gridTemplateColumns: 'repeat(2, 1fr)',
    gridTemplateRows: 'repeat(2, 1fr)',
    height: "".concat(size, "px"),
    justifyItems: 'center',
    minWidth: "".concat(size, "px"),
    overflow: 'hidden',
    width: "".concat(size, "px")
  };
};

var filteredAvatarGridProps = function filteredAvatarGridProps(props) {
  return (0, _util.filterProps)(props, ['backgroundColor', 'borderColor', 'items', 'size', 'borderWidth']);
};

var AvatarGrid = function AvatarGrid(_ref2) {
  var _ref2$borderWidth = _ref2.borderWidth,
      borderWidth = _ref2$borderWidth === void 0 ? 1 : _ref2$borderWidth,
      _ref2$size = _ref2.size,
      size = _ref2$size === void 0 ? _Avatar.DEFAULT_AVATAR_SIZE : _ref2$size,
      items = _ref2.items,
      fetchImages = _ref2.fetchImages,
      props = _objectWithoutProperties(_ref2, ["borderWidth", "size", "items", "fetchImages"]);

  var allProps = _objectSpread({
    borderWidth: borderWidth,
    items: items,
    size: size
  }, props);

  var slicedItems = items.slice(0, 4);
  var missing = 4 - slicedItems.length;

  for (var index = 0; index < missing; index++) {
    slicedItems.push(null);
  }

  return (0, _core.jsx)(_Misc.IsInViewport, _extends({
    checkViewportOnce: true,
    onEnterViewport: fetchImages,
    css: avatarGridStyle(allProps)
  }, filteredAvatarGridProps(allProps)), slicedItems.map(function (item) {
    return item ? (0, _core.jsx)(_Avatar.Avatar, {
      key: Math.random().toString(),
      backgroundColor: item.backgroundColor || _colors.COLOR.GRAY_DARKEN_80,
      base64Image: item.base64Image,
      color: item.color,
      forceInitials: item.forceInitials,
      isAvatarGridItem: true,
      name: item.name,
      size: size / 2 - borderWidth,
      style: {
        height: '100%',
        width: '100%'
      }
    }) : (0, _core.jsx)("div", {
      css: /*#__PURE__*/(0, _css2["default"])({
        backgroundColor: _colors.COLOR.GRAY_DARKEN_80,
        height: '100%',
        width: '100%'
      }, ";label:AvatarGrid;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"))
    });
  }));
};

exports.AvatarGrid = AvatarGrid;
//# sourceMappingURL=AvatarGrid.js.map