"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.COLOR = void 0;

var _color = _interopRequireDefault(require("color"));

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var steps = [];
var percent = 100;

for (var index = 8; index < percent; index += 8) {
  steps.push(index);
}

function shade(color) {
  var amount = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 0.08;
  return (0, _color["default"])(color).mix((0, _color["default"])(BASE_COLOR.BLACK), amount).toString();
}

function tint(color, amount) {
  return (0, _color["default"])(color).mix((0, _color["default"])(BASE_COLOR.WHITE), amount).toString();
}

function opaque(color, amount) {
  return (0, _color["default"])(color).fade(1 - amount).toString();
}

var BASE_COLOR = {
  BLACK: '#000',
  BLUE: '#0c78ba',
  GRAY: '#bac8d1',
  GREEN: '#00c800',
  ORANGE: '#ff8900',
  RED: '#e02020',
  WHITE: '#fff',
  YELLOW: '#febf02'
};
var DARK_COLOR = {};
var LIGHT_COLOR = {};
var OPAQUE_COLOR = {};
Object.entries({
  BLACK: BASE_COLOR.BLACK,
  GRAY: BASE_COLOR.GRAY,
  WHITE: BASE_COLOR.WHITE
}).forEach(function (_ref) {
  var _ref2 = _slicedToArray(_ref, 2),
      key = _ref2[0],
      value = _ref2[1];

  steps.forEach(function (step) {
    var amount = step / percent;
    DARK_COLOR["".concat(key, "_DARKEN_").concat(step)] = shade(value, amount);
    LIGHT_COLOR["".concat(key, "_LIGHTEN_").concat(step)] = tint(value, amount);
  });
});
Object.entries(BASE_COLOR).forEach(function (_ref3) {
  var _ref4 = _slicedToArray(_ref3, 2),
      key = _ref4[0],
      value = _ref4[1];

  steps.forEach(function (step) {
    var amount = step / percent;
    OPAQUE_COLOR["".concat(key, "_OPAQUE_").concat(step)] = opaque(value, amount);
  });
});
var COMPONENT_COLOR = {
  DISABLED: opaque(DARK_COLOR.GRAY_DARKEN_32, 0.16),
  ICON: DARK_COLOR.GRAY_DARKEN_72,
  LINK: DARK_COLOR.GRAY_DARKEN_72,
  TEXT: DARK_COLOR.GRAY_DARKEN_72
};

var COLOR = _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, BASE_COLOR), DARK_COLOR), LIGHT_COLOR), OPAQUE_COLOR), COMPONENT_COLOR), {}, {
  BLACK: BASE_COLOR.BLACK,
  WHITE: BASE_COLOR.WHITE,
  opaque: opaque,
  shade: shade,
  tint: tint
});

exports.COLOR = COLOR;
//# sourceMappingURL=colors.js.map