"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Column = exports.Columns = exports.filterColumnsProps = void 0;

var _core = require("@emotion/core");

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _sizes = require("./sizes");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var filterColumnsProps = function filterColumnsProps(props) {
  return (0, _util.filterProps)(props, ['query']);
};

exports.filterColumnsProps = filterColumnsProps;

var columnsStyle = function columnsStyle(_ref) {
  var _ref$query = _ref.query,
      query = _ref$query === void 0 ? _mediaQueries.QueryKeys.MOBILE : _ref$query;
  return _defineProperty({
    display: 'flex',
    marginLeft: "-".concat(_sizes.GUTTER, "px")
  }, _mediaQueries.media[query], {
    flexDirection: 'column'
  });
};

var Columns = function Columns(props) {
  return (0, _core.jsx)("div", _extends({
    css: columnsStyle(props)
  }, filterColumnsProps(props)));
};

exports.Columns = Columns;

var columnStyle = function columnStyle(props) {
  return {
    display: 'block',
    flexBasis: '0',
    flexGrow: 1,
    flexShrink: 1,
    marginLeft: "".concat(_sizes.GUTTER, "px")
  };
};

var Column = function Column(props) {
  return (0, _core.jsx)("div", _extends({
    css: columnStyle(props)
  }, props));
};

exports.Column = Column;
//# sourceMappingURL=Column.js.map