"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ContainerXXS = exports.ContainerXS = exports.ContainerSM = exports.ContainerMD = exports.ContainerLG = exports.Container = void 0;

var _core = require("@emotion/core");

var _react = _interopRequireDefault(require("react"));

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _sizes = require("./sizes");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var LEVEL = {
  lg: _sizes.WIDTH.DESKTOP_MAX,
  md: _sizes.WIDTH.TABLET_MAX,
  sm: _sizes.WIDTH.TABLET_MIN,
  xs: _sizes.WIDTH.MOBILE,
  xxs: _sizes.WIDTH.TINY
};

var containerStyle = function containerStyle(_ref) {
  var _ref$centerText = _ref.centerText,
      centerText = _ref$centerText === void 0 ? false : _ref$centerText,
      _ref$level = _ref.level,
      level = _ref$level === void 0 ? undefined : _ref$level,
      _ref$verticalCenter = _ref.verticalCenter,
      verticalCenter = _ref$verticalCenter === void 0 ? false : _ref$verticalCenter;
  return _defineProperty({
    margin: verticalCenter ? 'auto' : '0 auto',
    maxWidth: level ? "".concat(LEVEL[level], "px") : undefined,
    position: 'relative',
    textAlign: centerText ? 'center' : 'left',
    width: '100%'
  }, _mediaQueries.media[_mediaQueries.QueryKeys.DESKTOP], level ? undefined : {
    padding: 0,
    width: "".concat(_sizes.WIDTH.DESKTOP_MIN - _sizes.GUTTER * 2, "px")
  });
};

var filterContainerProps = function filterContainerProps(props) {
  return (0, _util.filterProps)(props, ['centerText', 'level', 'verticalCenter']);
};

var Container = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)("div", _extends({
    ref: ref,
    css: containerStyle(props)
  }, filterContainerProps(props)));
});

exports.Container = Container;

var ContainerLG = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)(Container, _extends({
    ref: ref,
    level: 'lg'
  }, props));
});

exports.ContainerLG = ContainerLG;

var ContainerMD = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)(Container, _extends({
    ref: ref,
    level: 'md'
  }, props));
});

exports.ContainerMD = ContainerMD;

var ContainerSM = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)(Container, _extends({
    ref: ref,
    level: 'sm'
  }, props));
});

exports.ContainerSM = ContainerSM;

var ContainerXS = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)(Container, _extends({
    ref: ref,
    level: 'xs'
  }, props));
});

exports.ContainerXS = ContainerXS;

var ContainerXXS = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)(Container, _extends({
    ref: ref,
    level: 'xxs'
  }, props));
});

exports.ContainerXXS = ContainerXXS;
//# sourceMappingURL=Container.js.map