"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FlexBox = exports.flexBoxStyle = void 0;

var _core = require("@emotion/core");

var _react = _interopRequireDefault(require("react"));

var _util = require("../util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var flexBoxStyle = function flexBoxStyle(_ref) {
  var _ref$align = _ref.align,
      align = _ref$align === void 0 ? 'flex-start' : _ref$align,
      _ref$column = _ref.column,
      column = _ref$column === void 0 ? false : _ref$column,
      _ref$justify = _ref.justify,
      justify = _ref$justify === void 0 ? 'flex-start' : _ref$justify,
      _ref$flexWrap = _ref.flexWrap,
      flexWrap = _ref$flexWrap === void 0 ? 'nowrap' : _ref$flexWrap;
  return {
    alignItems: align,
    display: 'flex',
    flexDirection: column ? 'column' : 'row',
    flexWrap: flexWrap,
    justifyContent: justify
  };
};

exports.flexBoxStyle = flexBoxStyle;

var filterFlexBoxProps = function filterFlexBoxProps(props) {
  return (0, _util.filterProps)(props, ['align', 'column', 'justify', 'flexWrap']);
};

var FlexBox = /*#__PURE__*/_react["default"].forwardRef(function (props, ref) {
  return (0, _core.jsx)("div", _extends({
    ref: ref,
    css: flexBoxStyle(props)
  }, filterFlexBoxProps(props)));
});

exports.FlexBox = FlexBox;
//# sourceMappingURL=FlexBox.js.map