"use strict";

function _typeof(obj) { "@babel/helpers - typeof"; if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") { _typeof = function _typeof(obj) { return typeof obj; }; } else { _typeof = function _typeof(obj) { return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj; }; } return _typeof(obj); }

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.IsTabletUp = exports.IsTabletDown = exports.IsTablet = exports.IsMobileUp = exports.IsMobileDown = exports.IsMobile = exports.IsDesktopXL = exports.IsDesktop = exports.MatchMedia = exports.useMatchMedia = void 0;

var _core = require("@emotion/core");

var _react = _interopRequireWildcard(require("react"));

var _mediaQueries = require("../mediaQueries");

function _getRequireWildcardCache() { if (typeof WeakMap !== "function") return null; var cache = new WeakMap(); _getRequireWildcardCache = function _getRequireWildcardCache() { return cache; }; return cache; }

function _interopRequireWildcard(obj) { if (obj && obj.__esModule) { return obj; } if (obj === null || _typeof(obj) !== "object" && typeof obj !== "function") { return { "default": obj }; } var cache = _getRequireWildcardCache(); if (cache && cache.has(obj)) { return cache.get(obj); } var newObj = {}; var hasPropertyDescriptor = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var key in obj) { if (Object.prototype.hasOwnProperty.call(obj, key)) { var desc = hasPropertyDescriptor ? Object.getOwnPropertyDescriptor(obj, key) : null; if (desc && (desc.get || desc.set)) { Object.defineProperty(newObj, key, desc); } else { newObj[key] = obj[key]; } } } newObj["default"] = obj; if (cache) { cache.set(obj, newObj); } return newObj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _slicedToArray(arr, i) { return _arrayWithHoles(arr) || _iterableToArrayLimit(arr, i) || _unsupportedIterableToArray(arr, i) || _nonIterableRest(); }

function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }

function _unsupportedIterableToArray(o, minLen) { if (!o) return; if (typeof o === "string") return _arrayLikeToArray(o, minLen); var n = Object.prototype.toString.call(o).slice(8, -1); if (n === "Object" && o.constructor) n = o.constructor.name; if (n === "Map" || n === "Set") return Array.from(o); if (n === "Arguments" || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(n)) return _arrayLikeToArray(o, minLen); }

function _arrayLikeToArray(arr, len) { if (len == null || len > arr.length) len = arr.length; for (var i = 0, arr2 = new Array(len); i < len; i++) { arr2[i] = arr[i]; } return arr2; }

function _iterableToArrayLimit(arr, i) { if (typeof Symbol === "undefined" || !(Symbol.iterator in Object(arr))) return; var _arr = []; var _n = true; var _d = false; var _e = undefined; try { for (var _i = arr[Symbol.iterator](), _s; !(_n = (_s = _i.next()).done); _n = true) { _arr.push(_s.value); if (i && _arr.length === i) break; } } catch (err) { _d = true; _e = err; } finally { try { if (!_n && _i["return"] != null) _i["return"](); } finally { if (_d) throw _e; } } return _arr; }

function _arrayWithHoles(arr) { if (Array.isArray(arr)) return arr; }

var useMatchMedia = function useMatchMedia(query) {
  var matchMedia = window.matchMedia("(".concat(query, ")"));

  var _useState = (0, _react.useState)(matchMedia.matches),
      _useState2 = _slicedToArray(_useState, 2),
      isMatching = _useState2[0],
      setIsMatching = _useState2[1];

  var updateMatching = function updateMatching() {
    return setIsMatching(matchMedia.matches);
  };

  (0, _react.useEffect)(function () {
    matchMedia.addListener(updateMatching);
    return function () {
      return matchMedia.removeListener(updateMatching);
    };
  });
  return isMatching;
};

exports.useMatchMedia = useMatchMedia;

var MatchMedia = function MatchMedia(_ref) {
  var query = _ref.query,
      children = _ref.children,
      not = _ref.not;
  var matchQuery = useMatchMedia(_mediaQueries.QUERY[query] || query);
  var isMatching = not ? !matchQuery : matchQuery;
  return (0, _core.jsx)(_react["default"].Fragment, null, isMatching ? children : null);
};

exports.MatchMedia = MatchMedia;

var IsDesktop = function IsDesktop(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.DESKTOP
  }, props));
};

exports.IsDesktop = IsDesktop;

var IsDesktopXL = function IsDesktopXL(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.DESKTOP_XL
  }, props));
};

exports.IsDesktopXL = IsDesktopXL;

var IsMobile = function IsMobile(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.MOBILE
  }, props));
};

exports.IsMobile = IsMobile;

var IsMobileDown = function IsMobileDown(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.MOBILE_DOWN
  }, props));
};

exports.IsMobileDown = IsMobileDown;

var IsMobileUp = function IsMobileUp(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.MOBILE_UP
  }, props));
};

exports.IsMobileUp = IsMobileUp;

var IsTablet = function IsTablet(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.TABLET
  }, props));
};

exports.IsTablet = IsTablet;

var IsTabletDown = function IsTabletDown(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.TABLET_DOWN
  }, props));
};

exports.IsTabletDown = IsTabletDown;

var IsTabletUp = function IsTabletUp(props) {
  return (0, _core.jsx)(MatchMedia, _extends({
    query: _mediaQueries.QueryKeys.TABLET_UP
  }, props));
};

exports.IsTabletUp = IsTabletUp;
//# sourceMappingURL=MatchMedia.js.map