"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.StyledApp = void 0;

var _core = require("@emotion/core");

var _GlobalStyle = require("../GlobalStyle");

var _util = require("../util");

var _Theme = require("./Theme");

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var styledAppContainerStyle = function styledAppContainerStyle(theme, _ref) {
  var _ref$backgroundColor = _ref.backgroundColor,
      backgroundColor = _ref$backgroundColor === void 0 ? theme.general.backgroundColor : _ref$backgroundColor;
  return {
    background: backgroundColor,
    transition: 'background 0.15s'
  };
};

var filterStyledAppContainerProps = function filterStyledAppContainerProps(props) {
  return (0, _util.filterProps)(props, ['backgroundColor', 'themeId']);
};

var StyledAppContainer = function StyledAppContainer(props) {
  return (0, _core.jsx)("div", _extends({
    css: function css(theme) {
      return styledAppContainerStyle(theme, props);
    }
  }, filterStyledAppContainerProps(props)));
};

var StyledApp = function StyledApp(_ref2) {
  var _ref2$themeId = _ref2.themeId,
      themeId = _ref2$themeId === void 0 ? _Theme.THEME_ID.LIGHT : _ref2$themeId,
      children = _ref2.children,
      props = _objectWithoutProperties(_ref2, ["themeId", "children"]);

  return (0, _core.jsx)(_Theme.ThemeProvider, {
    themeId: themeId
  }, (0, _core.jsx)(StyledAppContainer, props, (0, _core.jsx)(_GlobalStyle.GlobalStyle, null), children));
};

exports.StyledApp = StyledApp;
//# sourceMappingURL=StyledApp.js.map