"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ThemeProvider = exports.themes = exports.THEME_ID = void 0;

var _core = require("@emotion/core");

var _emotionTheming = require("emotion-theming");

var _colors = require("../Identity/colors");

var _util = require("../util");

var _themes;

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var THEME_ID;
exports.THEME_ID = THEME_ID;

(function (THEME_ID) {
  THEME_ID["DARK"] = "THEME_DARK";
  THEME_ID["LIGHT"] = "THEME_LIGHT";
})(THEME_ID || (exports.THEME_ID = THEME_ID = {}));

var themes = (_themes = {}, _defineProperty(_themes, THEME_ID.LIGHT, {
  Input: {
    backgroundColor: _colors.COLOR.WHITE,
    backgroundColorDisabled: _colors.COLOR.DISABLED,
    placeholderColor: _colors.COLOR.GRAY_DARKEN_24
  },
  general: {
    backgroundColor: _colors.COLOR.GRAY_LIGHTEN_88,
    color: _colors.COLOR.TEXT
  }
}), _defineProperty(_themes, THEME_ID.DARK, {
  Input: {
    backgroundColor: _colors.COLOR.BLACK_LIGHTEN_24,
    backgroundColorDisabled: _colors.COLOR.DISABLED,
    placeholderColor: _colors.COLOR.GRAY_LIGHTEN_88
  },
  general: {
    backgroundColor: _colors.COLOR.BLACK,
    color: _colors.COLOR.WHITE
  }
}), _themes);
exports.themes = themes;

var filterThemeProps = function filterThemeProps(props) {
  return (0, _util.filterProps)(props, ['themeId']);
};

var ThemeProvider = function ThemeProvider(props) {
  return (0, _core.jsx)(_emotionTheming.ThemeProvider, _extends({
    theme: themes[props.themeId]
  }, filterThemeProps(props)));
};

exports.ThemeProvider = ThemeProvider;
//# sourceMappingURL=Theme.js.map