"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.HeaderSubMenu = exports.MobileStyledHeaderSubMenu = exports.DesktopStyledHeaderSubMenu = exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME = void 0;

var _core = require("@emotion/core");

var _Identity = require("../../Identity");

var _motions = require("../../Identity/motions");

var _mediaQueries = require("../../mediaQueries");

var _MenuSubLink = require("./MenuSubLink");

var _MenuLink = require("./MenuLink");

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var desktopStyledHeaderSubMenuStyle = function desktopStyledHeaderSubMenuStyle(theme, props) {
  return _defineProperty({
    alignItems: 'left',
    backgroundColor: _Identity.COLOR.tint(theme.general.backgroundColor, 0.16),
    borderRadius: '8px',
    boxShadow: '0 8px 24px 0 rgba(0, 0, 0, 0.16)',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    minWidth: '200px',
    padding: '8px 8px',
    span: {
      '&:hover': {
        backgroundColor: theme.general.backgroundColor,
        borderRadius: '4px'
      },
      alignItems: 'center',
      display: 'flex',
      height: '30px',
      margin: 0,
      paddingLeft: '10px !important',
      paddingRight: '10px !important',
      whiteSpace: 'nowrap'
    }
  }, ".".concat(_MenuLink.MENU_LINK_CLASSNAME, ":nth-of-type(n+2)"), {
    marginTop: '8px'
  });
};

var DESKTOP_HEADER_SUB_MENU_CLASSNAME = 'desktopStyledHeaderSubMenu';
exports.DESKTOP_HEADER_SUB_MENU_CLASSNAME = DESKTOP_HEADER_SUB_MENU_CLASSNAME;

var DesktopStyledHeaderSubMenu = function DesktopStyledHeaderSubMenu(props) {
  return (0, _core.jsx)("div", _extends({
    className: DESKTOP_HEADER_SUB_MENU_CLASSNAME,
    css: function css(theme) {
      return desktopStyledHeaderSubMenuStyle(theme, props);
    }
  }, props));
};

exports.DesktopStyledHeaderSubMenu = DesktopStyledHeaderSubMenu;

var mobileStyledHeaderSubMenuStyle = function mobileStyledHeaderSubMenuStyle(props) {
  return {
    '*': {
      fontWeight: 200
    },
    alignItems: 'center',
    borderTop: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72),
    display: 'flex',
    flexDirection: 'column',
    justifyContent: 'center',
    marginTop: '16px',
    paddingTop: '8px'
  };
};

var MobileStyledHeaderSubMenu = function MobileStyledHeaderSubMenu(props) {
  return (0, _core.jsx)("span", _extends({
    css: mobileStyledHeaderSubMenuStyle(props)
  }, props));
};

exports.MobileStyledHeaderSubMenu = MobileStyledHeaderSubMenu;

var HeaderSubMenu = function HeaderSubMenu(_ref2) {
  var caption = _ref2.caption,
      isOpen = _ref2.isOpen,
      children = _ref2.children,
      props = _objectWithoutProperties(_ref2, ["caption", "isOpen", "children"]);

  var isDesktop = typeof window !== 'undefined' && window.matchMedia("(".concat(_mediaQueries.QUERY.desktop, ")")).matches;
  return (0, _core.jsx)(_MenuSubLink.MenuSubLink, _extends({}, props, {
    style: {
      cursor: 'pointer',
      display: 'inline-block',
      position: 'relative',
      textAlign: 'center'
    }
  }), (0, _core.jsx)("span", null, caption), (0, _core.jsx)(_Identity.Opacity, {
    "in": isOpen && isDesktop,
    timeout: _motions.DURATION.DEFAULT,
    style: {
      display: 'inline-block',
      left: -18,
      marginTop: 10,
      paddingTop: 20,
      position: 'absolute',
      zIndex: 1
    },
    mountOnEnter: false,
    unmountOnExit: false
  }, (0, _core.jsx)(_Identity.YAxisMovement, {
    "in": isOpen && isDesktop,
    startValue: '-30px',
    endValue: '0px',
    style: {
      display: 'inline-block'
    },
    timeout: _motions.DURATION.DEFAULT,
    mountOnEnter: false,
    unmountOnExit: true
  }, (0, _core.jsx)(DesktopStyledHeaderSubMenu, null, children))), (0, _core.jsx)(_Identity.Opacity, {
    "in": isOpen && !isDesktop,
    timeout: _motions.DURATION.DEFAULT,
    mountOnEnter: false,
    unmountOnExit: false,
    style: {
      display: 'block',
      position: 'relative'
    }
  }, (0, _core.jsx)(_Identity.Slide, {
    "in": isOpen && !isDesktop,
    startValue: '-56%',
    endValue: '0',
    timeout: _motions.DURATION.DEFAULT,
    mountOnEnter: false,
    unmountOnExit: true
  }, (0, _core.jsx)(MobileStyledHeaderSubMenu, null, children))));
};

exports.HeaderSubMenu = HeaderSubMenu;
//# sourceMappingURL=HeaderSubMenu.js.map