"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuContent = exports.menuContentStyle = void 0;

var _core = require("@emotion/core");

var _util = require("../../util");

var _Content = require("../Content");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var menuContentStyle = function menuContentStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Content.contentStyle)(props)), {}, {
    alignItems: 'center',
    display: 'grid',
    gridColumnGap: '8px',
    gridTemplateColumns: '1fr auto 1fr',
    height: '64px',
    justifyContent: 'space-between',
    left: props.open ? 0 : undefined,
    position: props.open ? 'fixed' : undefined,
    width: props.open ? '100%' : undefined,
    zIndex: props.open ? 10000 : undefined
  });
};

exports.menuContentStyle = menuContentStyle;

var filterMenuContentProps = function filterMenuContentProps(props) {
  return (0, _util.filterProps)(props, ['open']);
};

var MenuContent = function MenuContent(props) {
  return (0, _core.jsx)("div", _extends({
    css: menuContentStyle(props)
  }, filterMenuContentProps(props)));
};

exports.MenuContent = MenuContent;
//# sourceMappingURL=MenuContent.js.map