"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItems = exports.menuItemsStyle = void 0;

var _core = require("@emotion/core");

var _mediaQueries = require("../../mediaQueries");

var _util = require("../../util");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var menuItemsStyle = function menuItemsStyle(theme, props) {
  return _defineProperty({
    alignSelf: 'center',
    display: 'flex',
    justifySelf: 'end'
  }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
    backgroundColor: theme.general.backgroundColor,
    bottom: 0,
    left: 0,
    overflowY: 'auto',
    position: 'fixed',
    right: 0,
    top: 0,
    transform: props.open ? 'translateX(0)' : 'translateX(110%)',
    transition: 'transform 0.25s ease',
    zIndex: 1
  });
};

exports.menuItemsStyle = menuItemsStyle;

var filterMenuItemProps = function filterMenuItemProps(props) {
  return (0, _util.filterProps)(props, ['open']);
};

var MenuItems = function MenuItems(props) {
  return (0, _core.jsx)("div", _extends({
    css: function css(theme) {
      return menuItemsStyle(theme, props);
    }
  }, filterMenuItemProps(props)));
};

exports.MenuItems = MenuItems;
//# sourceMappingURL=MenuItems.js.map