"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuOpenButton = exports.menuOpenButtonStyle = void 0;

var _core = require("@emotion/core");

var _mediaQueries = require("../../mediaQueries");

var _util = require("../../util");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var menuOpenButtonStyle = function menuOpenButtonStyle(theme, _ref) {
  var _ref2;

  var open = _ref.open;
  return _ref2 = {
    display: 'block',
    div: {
      backgroundColor: theme.general.color,
      height: '2px',
      margin: '4px',
      transition: 'all 0.25s ease-in-out',
      width: '16px'
    },
    'div:nth-child(1)': {
      transform: open ? 'translateY(6px) rotate(-45deg)' : undefined
    },
    'div:nth-child(2)': {
      opacity: open ? 0 : undefined,
      transform: open ? 'scale(0, 1)' : undefined
    },
    'div:nth-child(3)': {
      transform: open ? 'translateY(-6px) rotate(45deg)' : undefined
    }
  }, _defineProperty(_ref2, _mediaQueries.media[_mediaQueries.QueryKeys.DESKTOP], {
    display: 'none'
  }), _defineProperty(_ref2, "zIndex", 2), _ref2;
};

exports.menuOpenButtonStyle = menuOpenButtonStyle;

var filterMenuOpenButtonProps = function filterMenuOpenButtonProps(props) {
  return (0, _util.filterProps)(props, ['open']);
};

var MenuOpenButton = function MenuOpenButton(props) {
  return (0, _core.jsx)("div", _extends({
    css: function css(theme) {
      return menuOpenButtonStyle(theme, props);
    }
  }, filterMenuOpenButtonProps(props)), (0, _core.jsx)("div", null), (0, _core.jsx)("div", null), (0, _core.jsx)("div", null));
};

exports.MenuOpenButton = MenuOpenButton;
//# sourceMappingURL=MenuOpenButton.js.map