"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MenuItem = exports.MenuModal = void 0;

var _css2 = _interopRequireDefault(require("@emotion/css"));

var _core = require("@emotion/core");

var _Identity = require("../Identity/");

var _motions = require("../Identity/motions");

var _mediaQueries = require("../mediaQueries");

var _Overlay = require("../Modal/Overlay");

var _util = require("../util");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var menuModalWrapperStyle = function menuModalWrapperStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Overlay.overlayBackgroundStyle)(props)), {}, {
    alignItems: 'flex-end',
    alignSelf: 'flex-end',
    display: 'flex',
    overflowY: 'hidden',
    padding: 0
  });
};

var MenuModalWrapper = function MenuModalWrapper(props) {
  return (0, _core.jsx)("div", _extends({
    css: menuModalWrapperStyle
  }, props));
};

var MenuModalBody = function MenuModalBody(props) {
  return (0, _core.jsx)("div", _extends({
    css: function css(theme) {
      return _defineProperty({
        animation: "".concat(_motions.ANIMATION.bottomUpMovement, " ").concat(_motions.DURATION.DEFAULT, "ms ").concat(_motions.EASE.EXPONENTIAL),
        backgroundColor: _Identity.COLOR.tint(theme.general.backgroundColor, 0.16),
        boxShadow: '0 16px 64px 0 rgba(0, 0, 0, 0.16)',
        display: 'flex',
        flexDirection: 'column',
        justifyContent: 'space-between',
        marginLeft: 'auto',
        marginRight: 'auto',
        padding: '8px 16px',
        position: 'relative',
        width: '767px',
        zIndex: 9999
      }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
        width: '100%'
      });
    }
  }, props));
};

var MenuModalContent = function MenuModalContent(props) {
  return (0, _core.jsx)("ul", _extends({
    css: /*#__PURE__*/(0, _css2["default"])({
      li: {
        borderBottom: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72)
      },
      'li:last-child': {
        borderBottom: 0
      },
      margin: 0,
      maxWidth: '100%',
      minWidth: '100%',
      padding: 0
    }, ";label:MenuModalContent;" + (process.env.NODE_ENV === "production" ? "" : "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */"))
  }, props));
};

var modalBackgroundStyle = function modalBackgroundStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Overlay.overlayBackgroundStyle)(props)), {}, {
    background: 'rgba(50, 54, 57, 0.4)'
  });
};

var MenuModalBackground = function MenuModalBackground(props) {
  return (0, _core.jsx)("div", _extends({
    css: modalBackgroundStyle
  }, props));
};

var MenuModal = function MenuModal(_ref2) {
  var _ref2$children = _ref2.children,
      children = _ref2$children === void 0 ? null : _ref2$children,
      _ref2$onBackgroundCli = _ref2.onBackgroundClick,
      onBackgroundClick = _ref2$onBackgroundCli === void 0 ? _util.noop : _ref2$onBackgroundCli,
      props = _objectWithoutProperties(_ref2, ["children", "onBackgroundClick"]);

  return (0, _core.jsx)(MenuModalWrapper, props, (0, _core.jsx)(MenuModalBody, null, (0, _core.jsx)(MenuModalContent, null, children)), (0, _core.jsx)(MenuModalBackground, {
    onClick: onBackgroundClick,
    "data-uie-name": "menu-background"
  }));
};

exports.MenuModal = MenuModal;

var MenuItem = function MenuItem(_ref3) {
  var _ref3$children = _ref3.children,
      children = _ref3$children === void 0 ? null : _ref3$children,
      props = _objectWithoutProperties(_ref3, ["children"]);

  return (0, _core.jsx)("li", _extends({
    css: function css(theme) {
      return {
        alignItems: 'center',
        color: theme.general.color,
        cursor: 'pointer',
        display: 'flex',
        height: '56px',
        listStyleType: 'none',
        maxWidth: '100%'
      };
    }
  }, props), children);
};

exports.MenuItem = MenuItem;
//# sourceMappingURL=MenuModal.js.map