"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TabBarItem = exports.TabBar = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _Text = require("../Text");

var _util = require("../util");

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function _objectDestructuringEmpty(obj) { if (obj == null) throw new TypeError("Cannot destructure undefined"); }

var tabBarStyle = function tabBarStyle(_ref) {
  _objectDestructuringEmpty(_ref);

  return {
    display: 'flex',
    width: '100%'
  };
};

var filteredTabBarProps = function filteredTabBarProps(props) {
  return (0, _util.filterProps)(props, []);
};

var TabBar = function TabBar(_ref2) {
  var _ref2$children = _ref2.children,
      children = _ref2$children === void 0 ? null : _ref2$children,
      props = _objectWithoutProperties(_ref2, ["children"]);

  return (0, _core.jsx)("div", _extends({
    css: tabBarStyle(props)
  }, filteredTabBarProps(props)), children);
};

exports.TabBar = TabBar;

var tabBarItemStyle = function tabBarItemStyle(theme, _ref3) {
  var _ref3$block = _ref3.block,
      block = _ref3$block === void 0 ? true : _ref3$block,
      _ref3$center = _ref3.center,
      center = _ref3$center === void 0 ? true : _ref3$center,
      _ref3$color = _ref3.color,
      color = _ref3$color === void 0 ? theme.general.color : _ref3$color,
      _ref3$bold = _ref3.bold,
      bold = _ref3$bold === void 0 ? true : _ref3$bold,
      _ref3$active = _ref3.active,
      active = _ref3$active === void 0 ? false : _ref3$active,
      _ref3$fontSize = _ref3.fontSize,
      fontSize = _ref3$fontSize === void 0 ? '11px' : _ref3$fontSize,
      _ref3$textTransform = _ref3.textTransform,
      textTransform = _ref3$textTransform === void 0 ? 'uppercase' : _ref3$textTransform,
      props = _objectWithoutProperties(_ref3, ["block", "center", "color", "bold", "active", "fontSize", "textTransform"]);

  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    bold: bold,
    center: center,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props))), {}, {
    borderBottom: active ? "1px solid ".concat(_Identity.COLOR.GRAY_DARKEN_48) : "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_40),
    cursor: 'pointer',
    display: 'flex',
    flexGrow: 1,
    justifyContent: 'center',
    opacity: active ? 1 : 0.56,
    padding: '8px 0'
  });
};

var TabBarItem = function TabBarItem(_ref4) {
  var _ref4$children = _ref4.children,
      children = _ref4$children === void 0 ? null : _ref4$children,
      props = _objectWithoutProperties(_ref4, ["children"]);

  return (0, _core.jsx)("span", _extends({
    css: function css(theme) {
      return tabBarItemStyle(theme, props);
    }
  }, props), children);
};

exports.TabBarItem = TabBarItem;
//# sourceMappingURL=TabBar.js.map