"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Loading = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _templateObject() {
  var data = _taggedTemplateLiteral(["\n    0% {\n      stroke-dashoffset: ", ";\n    }\n    100% {\n      stroke-dashoffset: 0;\n    }\n  "]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var Loading = function Loading(_ref) {
  var _ref$progress = _ref.progress,
      progress = _ref$progress === void 0 ? undefined : _ref$progress,
      _ref$size = _ref.size,
      size = _ref$size === void 0 ? 43 : _ref$size,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? '#218fd1' : _ref$color,
      props = _objectWithoutProperties(_ref, ["progress", "size", "color"]);

  var pathLength = 125.68;
  var rotationOffset = -0.75;
  var rotationDelay = _motions.DURATION.EXTRA_LONG * rotationOffset;
  var fillAnimation = (0, _core.keyframes)(_templateObject(), pathLength + pathLength);
  return (0, _core.jsx)("svg", _extends({
    width: size,
    height: size,
    viewBox: "0 0 43 43",
    strokeWidth: "3",
    fill: "none"
  }, props), (0, _core.jsx)("circle", {
    cx: "21.5",
    cy: "21.5",
    r: "20",
    stroke: _Identity.COLOR.opaque(color, 0.08)
  }), (0, _core.jsx)("circle", {
    css: !progress && {
      animation: "".concat(fillAnimation, " ").concat(_motions.DURATION.EXTRA_LONG, "ms ease-in-out infinite,\n              ").concat(_motions.ANIMATION.rotate, " ").concat(_motions.DURATION.EXTRA_LONG, "ms linear ").concat(rotationDelay, "ms infinite"),
      strokeDasharray: pathLength,
      transformOrigin: '50% 50%'
    },
    cx: "21.5",
    cy: "21.5",
    r: "20",
    stroke: color,
    strokeLinecap: "round",
    strokeDasharray: pathLength,
    strokeDashoffset: progress && "".concat(pathLength - pathLength * progress)
  }));
};

exports.Loading = Loading;
Loading.defaultProps = {
  progress: undefined,
  size: 43
};
//# sourceMappingURL=Loading.js.map