"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pagination = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _Layout = require("../Layout");

var _Text = require("../Text");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var _ref2 = process.env.NODE_ENV === "production" ? {
  name: "j5wv9j-Pagination",
  styles: "flex-basis:100px;;label:Pagination;"
} : {
  name: "j5wv9j-Pagination",
  styles: "flex-basis:100px;;label:Pagination;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1fw1u1c-Pagination",
  styles: "align-items:flex-end;display:flex;flex-direction:row;margin:0 auto;;label:Pagination;"
} : {
  name: "1fw1u1c-Pagination",
  styles: "align-items:flex-end;display:flex;flex-direction:row;margin:0 auto;;label:Pagination;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "1v8qry-Pagination",
  styles: "display:flex;flex-basis:100px;justify-content:flex-end;;label:Pagination;"
} : {
  name: "1v8qry-Pagination",
  styles: "display:flex;flex-basis:100px;justify-content:flex-end;;label:Pagination;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var Pagination = function Pagination(_ref) {
  var _ref$currentPage = _ref.currentPage,
      currentPage = _ref$currentPage === void 0 ? 0 : _ref$currentPage,
      _ref$numberOfPages = _ref.numberOfPages,
      numberOfPages = _ref$numberOfPages === void 0 ? 1 : _ref$numberOfPages,
      goPage = _ref.goPage,
      _ref$previousPageComp = _ref.previousPageComponent,
      PreviousPageComponent = _ref$previousPageComp === void 0 ? function () {
    return '<';
  } : _ref$previousPageComp,
      _ref$nextPageComponen = _ref.nextPageComponent,
      NextPageComponent = _ref$nextPageComponen === void 0 ? function () {
    return '>';
  } : _ref$nextPageComponen,
      props = _objectWithoutProperties(_ref, ["currentPage", "numberOfPages", "goPage", "previousPageComponent", "nextPageComponent"]);

  var isLastPage = currentPage === numberOfPages - 1;
  var isFirstPage = currentPage === 0;

  var renderPageList = function renderPageList() {
    var lastPageIndex = numberOfPages - 1;
    var spanLength = 1;
    var endLength = 1;
    var skipLength = 1;
    var normalizeCount = endLength + skipLength + spanLength;

    var dots = function dots(key) {
      return (0, _core.jsx)(_Text.Bold, {
        key: key,
        fontSize: '11px'
      }, '…');
    };

    var renderPageNumber = function renderPageNumber(pageIndex) {
      return currentPage === pageIndex ? (0, _core.jsx)(_Text.Bold, {
        fontSize: '11px',
        key: pageIndex,
        style: {
          color: _Identity.COLOR.BLUE,
          margin: '0 8px'
        },
        "data-uie-name": "status-active-page"
      }, pageIndex + 1) : (0, _core.jsx)(_Text.Link, {
        key: pageIndex,
        style: {
          margin: '0 8px'
        },
        onClick: function onClick() {
          return goPage(pageIndex);
        },
        "data-uie-name": "go-page"
      }, pageIndex + 1);
    };

    var normalizedCurrent = Math.min(Math.max(currentPage, normalizeCount), lastPageIndex - normalizeCount);
    var beforeCount = normalizedCurrent - spanLength - endLength;
    var afterCount = lastPageIndex - endLength - normalizedCurrent - spanLength;
    var pages = Array.from(Array(numberOfPages), function (nothing, index) {
      return renderPageNumber(index);
    });

    if (afterCount > skipLength) {
      pages.splice(normalizedCurrent + spanLength + 1, afterCount, dots('dots-end'));
    }

    if (beforeCount > skipLength) {
      pages.splice(endLength, beforeCount, dots('dots-start'));
    }

    return pages;
  };

  return (0, _core.jsx)(_Layout.FlexBox, _extends({
    align: "flex-end",
    "data-uie-name": "element-pagination"
  }, props), (0, _core.jsx)("div", {
    css: _ref2
  }, !isFirstPage && (0, _core.jsx)(_Text.Link, {
    block: true,
    onClick: function onClick() {
      return goPage(currentPage - 1);
    },
    "data-uie-name": "go-previous-page"
  }, (0, _core.jsx)(PreviousPageComponent, null))), (0, _core.jsx)("div", {
    css: _ref3,
    "data-uie-name": "list-pages"
  }, renderPageList()), (0, _core.jsx)("div", {
    css: _ref4
  }, !isLastPage && (0, _core.jsx)(_Text.Link, {
    block: true,
    onClick: function onClick() {
      return goPage(currentPage + 1);
    },
    "data-uie-name": "go-next-page"
  }, (0, _core.jsx)(NextPageComponent, null))));
};

exports.Pagination = Pagination;
//# sourceMappingURL=Pagination.js.map