"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Pill = exports.filterPillProps = exports.pillStyle = exports.PILL_TYPE = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _motions = require("../Identity/motions");

var _util = require("../util");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _templateObject() {
  var data = _taggedTemplateLiteral(["\n    0% {\n      background-color: transparent;\n    }\n    100% {\n      background-color: ", ";\n    }\n"]);

  _templateObject = function _templateObject() {
    return data;
  };

  return data;
}

function _taggedTemplateLiteral(strings, raw) { if (!raw) { raw = strings.slice(0); } return Object.freeze(Object.defineProperties(strings, { raw: { value: Object.freeze(raw) } })); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var PILL_TYPE;
exports.PILL_TYPE = PILL_TYPE;

(function (PILL_TYPE) {
  PILL_TYPE["error"] = "ERROR";
  PILL_TYPE["success"] = "SUCCESS";
  PILL_TYPE["warning"] = "WARNING";
})(PILL_TYPE || (exports.PILL_TYPE = PILL_TYPE = {}));

var pillStyle = function pillStyle(theme, _ref) {
  var _backgroundColors;

  var _ref$active = _ref.active,
      active = _ref$active === void 0 ? false : _ref$active,
      _ref$type = _ref.type,
      type = _ref$type === void 0 ? null : _ref$type;
  var backgroundColors = (_backgroundColors = {}, _defineProperty(_backgroundColors, PILL_TYPE.error, _Identity.COLOR.RED_OPAQUE_32), _defineProperty(_backgroundColors, PILL_TYPE.success, _Identity.COLOR.GREEN_OPAQUE_32), _defineProperty(_backgroundColors, PILL_TYPE.warning, _Identity.COLOR.YELLOW_OPAQUE_32), _backgroundColors);
  var backgroundColor = active ? '#eee' : type ? backgroundColors[type] : 'transparent';
  var pillAnimation = (0, _core.keyframes)(_templateObject(), backgroundColor);
  return {
    '&:first-of-type': {
      marginLeft: 0
    },
    '&:last-of-type': {
      marginRight: 0
    },
    animation: "".concat(pillAnimation, " ").concat(_motions.DURATION.DEFAULT, "ms ").concat(_motions.EASE.QUART),
    backgroundColor: backgroundColor,
    borderRadius: '160px',
    color: active ? _Identity.COLOR.TEXT : theme.general.color,
    cursor: active ? 'default' : undefined,
    display: 'inline-block',
    fontSize: '12px',
    lineHeight: '16px',
    margin: type ? '12px 0 0 0' : '0 8px',
    minHeight: '32px',
    padding: '8px 24px',
    textAlign: 'center',
    textDecoration: 'none'
  };
};

exports.pillStyle = pillStyle;

var filterPillProps = function filterPillProps(props) {
  return (0, _util.filterProps)(props, ['active']);
};

exports.filterPillProps = filterPillProps;

var Pill = function Pill(props) {
  return (0, _core.jsx)("span", _extends({
    css: function css(theme) {
      return pillStyle(theme, props);
    },
    "data-uie-name": "element-pill",
    "data-uie-status": props.type
  }, filterPillProps(props)));
};

exports.Pill = Pill;
//# sourceMappingURL=Pill.js.map