"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Modal = void 0;

var _core = require("@emotion/core");

var _color = _interopRequireDefault(require("color"));

var _Icon = require("../Icon");

var _Identity = require("../Identity");

var _mediaQueries = require("../mediaQueries");

var _util = require("../util");

var _Overlay = require("./Overlay");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

var modalBodyStyle = function modalBodyStyle(theme, _ref) {
  var _ref$fullscreen = _ref.fullscreen,
      fullscreen = _ref$fullscreen === void 0 ? false : _ref$fullscreen;
  return _defineProperty({
    alignItems: 'center',
    backgroundColor: _Identity.COLOR.tint(theme.general.backgroundColor, 0.16),
    borderRadius: fullscreen ? 0 : '8px',
    bottom: fullscreen ? 0 : undefined,
    boxShadow: fullscreen ? 'none' : '0 16px 64px 0 rgba(0, 0, 0, 0.16)',
    display: 'flex',
    flexDirection: 'column',
    justifyContent: fullscreen ? 'center' : 'space-between',
    left: fullscreen ? 0 : undefined,
    margin: 'auto',
    position: fullscreen ? 'fixed' : 'relative',
    right: fullscreen ? 0 : undefined,
    top: fullscreen ? 0 : undefined,
    transform: 'translate3d(0, 0, 0)',
    zIndex: 9999
  }, _mediaQueries.media[_mediaQueries.QueryKeys.TABLET_DOWN], {
    width: fullscreen ? 'initial' : '100%'
  });
};

var filterModalBodyProps = function filterModalBodyProps(props) {
  return (0, _util.filterProps)(props, ['fullscreen']);
};

var ModalBody = function ModalBody(props) {
  return (0, _core.jsx)("div", _extends({
    css: function css(theme) {
      return modalBodyStyle(theme, props);
    }
  }, filterModalBodyProps(props)));
};

var _ref3 = process.env.NODE_ENV === "production" ? {
  name: "1h0rnk9-ModalClose",
  styles: "align-items:center;cursor:pointer;display:flex;justify-content:center;position:absolute;right:16px;top:16px;;label:ModalClose;"
} : {
  name: "1h0rnk9-ModalClose",
  styles: "align-items:center;cursor:pointer;display:flex;justify-content:center;position:absolute;right:16px;top:16px;;label:ModalClose;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var ModalClose = function ModalClose(props) {
  return (0, _core.jsx)(_Icon.CloseIcon, _extends({
    width: 16,
    height: 16,
    css: _ref3
  }, props));
};

var _ref4 = process.env.NODE_ENV === "production" ? {
  name: "25orn5-ModalContent",
  styles: "max-width:100%;overflow-y:auto;padding:40px;;label:ModalContent;"
} : {
  name: "25orn5-ModalContent",
  styles: "max-width:100%;overflow-y:auto;padding:40px;;label:ModalContent;",
  map: "/*# sourceMappingURL=data:application/json;charset=utf-8;base64,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 */",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};

var ModalContent = function ModalContent(props) {
  return (0, _core.jsx)("div", _extends({
    css: _ref4
  }, props));
};

var modalBackgroundStyle = function modalBackgroundStyle(props) {
  return _objectSpread(_objectSpread({}, (0, _Overlay.overlayBackgroundStyle)(props)), {}, {
    backgroundColor: 'rgba(50, 54, 57, 0.4)'
  });
};

var ModalBackground = function ModalBackground(props) {
  return (0, _core.jsx)("div", _extends({
    css: modalBackgroundStyle(props)
  }, props));
};

var modalActionsWrapperStyles = function modalActionsWrapperStyles() {
  return {
    borderTop: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72),
    bottom: 0,
    display: 'flex',
    div: {
      '&:hover': {
        backgroundColor: _Identity.COLOR.opaque(_Identity.COLOR.GRAY_DARKEN_72, 0.04)
      },
      // eslint-disable-next-line sort-keys-fix/sort-keys-fix
      '&:active': {
        backgroundColor: _Identity.COLOR.opaque(_Identity.COLOR.GRAY_DARKEN_72, 0.08)
      },
      borderRight: "1px solid ".concat(_Identity.COLOR.GRAY_LIGHTEN_72)
    },
    'div:first-child': {
      borderBottomLeftRadius: 8
    },
    'div:last-child': {
      borderBottomRightRadius: 8,
      borderRight: 0
    },
    position: 'absolute',
    width: '100%'
  };
};

var modalActionStyles = function modalActionStyles(_ref5) {
  var bold = _ref5.bold;
  return {
    '&:hover': {
      color: (0, _color["default"])(_Identity.COLOR.BLUE).mix((0, _color["default"])(_Identity.COLOR.BLACK), 0.16).toString()
    },
    color: _Identity.COLOR.BLUE,
    cursor: 'pointer',
    display: 'flex',
    flex: 1,
    fontWeight: bold ? 'bold' : 'normal',
    justifyContent: 'center',
    padding: '8px 0'
  };
};

var ModalActions = function ModalActions(_ref6) {
  var actions = _ref6.actions;
  return (0, _core.jsx)("div", {
    css: modalActionsWrapperStyles()
  }, actions.map(function (action) {
    return (0, _core.jsx)("div", {
      key: action.title,
      onClick: action.onClick,
      css: modalActionStyles({
        bold: action.bold
      }),
      "data-uie-name": action.dataUieName
    }, action.title);
  }));
};

var Modal = function Modal(_ref7) {
  var _ref7$actions = _ref7.actions,
      actions = _ref7$actions === void 0 ? [] : _ref7$actions,
      children = _ref7.children,
      bodyStyle = _ref7.bodyStyle,
      fullscreen = _ref7.fullscreen,
      onClose = _ref7.onClose,
      onBackgroundClick = _ref7.onBackgroundClick,
      props = _objectWithoutProperties(_ref7, ["actions", "children", "bodyStyle", "fullscreen", "onClose", "onBackgroundClick"]);

  return (0, _core.jsx)(_Overlay.OverlayWrapper, _extends({}, props, {
    "data-uie-name": "modal"
  }), (0, _core.jsx)(ModalBody, {
    fullscreen: fullscreen,
    style: bodyStyle
  }, (0, _core.jsx)(ModalContent, null, children), onClose !== _util.noop && (0, _core.jsx)(ModalClose, {
    onClick: onClose,
    "data-uie-name": "do-close"
  }), actions.length > 0 && (0, _core.jsx)(ModalActions, {
    actions: actions,
    "data-uie-name": "modal-actions"
  })), !fullscreen && (0, _core.jsx)(ModalBackground, {
    onClick: onBackgroundClick === _util.noop ? onClose : onBackgroundClick,
    "data-uie-name": "modal-background"
  }));
};

exports.Modal = Modal;
Modal.defaultProps = {
  actions: [],
  fullscreen: false,
  onBackgroundClick: _util.noop,
  onClose: _util.noop
};
//# sourceMappingURL=Modal.js.map