"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Line = exports.lineStyle = void 0;

var _core = require("@emotion/core");

var _Identity = require("../Identity");

var _sizes = require("../Layout/sizes");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var lineStyle = function lineStyle(_ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? _Identity.COLOR.GRAY_LIGHTEN_72 : _ref$color;
  return {
    border: 'none',
    borderBottom: "1px solid ".concat(color),
    marginBottom: "".concat(_sizes.GUTTER, "px"),
    marginTop: "".concat(_sizes.GUTTER, "px")
  };
};

exports.lineStyle = lineStyle;

var Line = function Line(props) {
  return (0, _core.jsx)("hr", _extends({
    css: lineStyle(props)
  }, props));
};

exports.Line = Line;
//# sourceMappingURL=Line.js.map