"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Link = exports.filterLinkProps = exports.linkStyle = void 0;

var _core = require("@emotion/core");

var _color = _interopRequireDefault(require("color"));

var _colors = require("../Identity/colors");

var _motions = require("../Identity/motions");

var _util = require("../util");

var _Text = require("./Text");

function _interopRequireDefault(obj) { return obj && obj.__esModule ? obj : { "default": obj }; }

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var linkStyle = function linkStyle(theme, _ref) {
  var _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? true : _ref$bold,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '11px' : _ref$fontSize,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'uppercase' : _ref$textTransform,
      props = _objectWithoutProperties(_ref, ["bold", "color", "fontSize", "textTransform"]);

  var darker = 0.16;
  var hoverColor = (0, _color["default"])(color).mix((0, _color["default"])(_colors.COLOR.BLACK), darker).toString();
  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    bold: bold,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props))), {}, {
    '&:hover': {
      color: hoverColor
    },
    '&:visited, &:link, &:active': {
      color: color
    },
    color: color,
    cursor: 'pointer',
    textDecoration: 'none',
    transition: _motions.defaultTransition
  });
};

exports.linkStyle = linkStyle;

var filterLinkProps = function filterLinkProps(props) {
  return (0, _util.filterProps)((0, _Text.filterTextProps)(props), []);
};

exports.filterLinkProps = filterLinkProps;

var Link = function Link(props) {
  return (0, _core.jsx)("a", _extends({
    css: function css(theme) {
      return linkStyle(theme, props);
    },
    rel: "noopener noreferrer"
  }, filterLinkProps(props)), props.children);
};

exports.Link = Link;
//# sourceMappingURL=Link.js.map