"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Lead = exports.leadStyle = exports.Paragraph = exports.paragraphStyle = void 0;

var _core = require("@emotion/core");

var _mediaQueries = require("../mediaQueries");

var _Text = require("./Text");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var paragraphStyle = function paragraphStyle(theme, _ref) {
  var _ref$block = _ref.block,
      block = _ref$block === void 0 ? true : _ref$block,
      props = _objectWithoutProperties(_ref, ["block"]);

  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block
  }, props))), {}, {
    marginBottom: '16px',
    marginTop: 0
  });
};

exports.paragraphStyle = paragraphStyle;

var Paragraph = function Paragraph(props) {
  return (0, _core.jsx)("p", _extends({
    css: function css(theme) {
      return paragraphStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.Paragraph = Paragraph;

var leadStyle = function leadStyle(theme, _ref2) {
  var _ref2$block = _ref2.block,
      block = _ref2$block === void 0 ? true : _ref2$block,
      _ref2$center = _ref2.center,
      center = _ref2$center === void 0 ? true : _ref2$center,
      _ref2$fontSize = _ref2.fontSize,
      fontSize = _ref2$fontSize === void 0 ? '24px' : _ref2$fontSize,
      props = _objectWithoutProperties(_ref2, ["block", "center", "fontSize"]);

  return _objectSpread(_objectSpread({}, (0, _Text.textStyle)(theme, _objectSpread({
    block: block,
    center: center,
    fontSize: fontSize
  }, props))), {}, _defineProperty({
    marginBottom: '56px',
    marginTop: 0
  }, _mediaQueries.media[_mediaQueries.QueryKeys.MOBILE], {
    fontSize: '20px'
  }));
};

exports.leadStyle = leadStyle;

var Lead = function Lead(props) {
  return (0, _core.jsx)("p", _extends({
    css: function css(theme) {
      return leadStyle(theme, props);
    }
  }, (0, _Text.filterTextProps)(props)));
};

exports.Lead = Lead;
//# sourceMappingURL=Paragraph.js.map