"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Large = exports.Uppercase = exports.Muted = exports.Small = exports.Bold = exports.Text = exports.textStyle = exports.filterTextProps = void 0;

var _core = require("@emotion/core");

var _util = require("../util");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

var filterTextProps = function filterTextProps(props) {
  return (0, _util.filterProps)(props, ['block', 'bold', 'center', 'color', 'fontSize', 'light', 'muted', 'noWrap', 'textTransform', 'truncate']);
};

exports.filterTextProps = filterTextProps;

var textStyle = function textStyle(theme, _ref) {
  var _ref$block = _ref.block,
      block = _ref$block === void 0 ? false : _ref$block,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? false : _ref$bold,
      _ref$center = _ref.center,
      center = _ref$center === void 0 ? false : _ref$center,
      _ref$color = _ref.color,
      color = _ref$color === void 0 ? theme.general.color : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '16px' : _ref$fontSize,
      _ref$light = _ref.light,
      light = _ref$light === void 0 ? false : _ref$light,
      _ref$muted = _ref.muted,
      muted = _ref$muted === void 0 ? false : _ref$muted,
      _ref$noWrap = _ref.noWrap,
      noWrap = _ref$noWrap === void 0 ? false : _ref$noWrap,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      _ref$truncate = _ref.truncate,
      truncate = _ref$truncate === void 0 ? false : _ref$truncate;
  return {
    color: color,
    display: block ? 'block' : 'inline',
    fontSize: fontSize,
    fontWeight: bold ? 600 : light ? 200 : 300,
    opacity: muted ? 0.56 : 1,
    overflow: truncate ? 'hidden' : undefined,
    textAlign: center ? 'center' : 'left',
    textOverflow: truncate ? 'ellipsis' : undefined,
    textTransform: textTransform,
    whiteSpace: noWrap ? 'nowrap' : undefined
  };
};

exports.textStyle = textStyle;

var Text = function Text(props) {
  return (0, _core.jsx)("span", _extends({
    css: function css(theme) {
      return textStyle(theme, props);
    }
  }, filterTextProps(props)));
};

exports.Text = Text;

var Bold = function Bold(props) {
  return (0, _core.jsx)(Text, _extends({
    bold: true
  }, props));
};

exports.Bold = Bold;

var Small = function Small(props) {
  return (0, _core.jsx)(Text, _extends({
    fontSize: '12px'
  }, props));
};

exports.Small = Small;

var Muted = function Muted(props) {
  return (0, _core.jsx)(Text, _extends({
    muted: true
  }, props));
};

exports.Muted = Muted;

var Uppercase = function Uppercase(props) {
  return (0, _core.jsx)(Text, _extends({
    textTransform: 'uppercase'
  }, props));
};

exports.Uppercase = Uppercase;

var Large = function Large(props) {
  return (0, _core.jsx)(Text, _extends({
    fontSize: '48px',
    light: true
  }, props));
};

exports.Large = Large;
//# sourceMappingURL=Text.js.map