"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TextLink = exports.textLinkStyle = void 0;

var _core = require("@emotion/core");

var _colors = require("../Identity/colors");

var _Link = require("./Link");

function _extends() { _extends = Object.assign || function (target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i]; for (var key in source) { if (Object.prototype.hasOwnProperty.call(source, key)) { target[key] = source[key]; } } } return target; }; return _extends.apply(this, arguments); }

function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); if (enumerableOnly) symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; }); keys.push.apply(keys, symbols); } return keys; }

function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = arguments[i] != null ? arguments[i] : {}; if (i % 2) { ownKeys(Object(source), true).forEach(function (key) { _defineProperty(target, key, source[key]); }); } else if (Object.getOwnPropertyDescriptors) { Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)); } else { ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } } return target; }

function _defineProperty(obj, key, value) { if (key in obj) { Object.defineProperty(obj, key, { value: value, enumerable: true, configurable: true, writable: true }); } else { obj[key] = value; } return obj; }

function _objectWithoutProperties(source, excluded) { if (source == null) return {}; var target = _objectWithoutPropertiesLoose(source, excluded); var key, i; if (Object.getOwnPropertySymbols) { var sourceSymbolKeys = Object.getOwnPropertySymbols(source); for (i = 0; i < sourceSymbolKeys.length; i++) { key = sourceSymbolKeys[i]; if (excluded.indexOf(key) >= 0) continue; if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue; target[key] = source[key]; } } return target; }

function _objectWithoutPropertiesLoose(source, excluded) { if (source == null) return {}; var target = {}; var sourceKeys = Object.keys(source); var key, i; for (i = 0; i < sourceKeys.length; i++) { key = sourceKeys[i]; if (excluded.indexOf(key) >= 0) continue; target[key] = source[key]; } return target; }

var textLinkStyle = function textLinkStyle(theme, _ref) {
  var _ref$color = _ref.color,
      color = _ref$color === void 0 ? _colors.COLOR.BLUE : _ref$color,
      _ref$fontSize = _ref.fontSize,
      fontSize = _ref$fontSize === void 0 ? '16px' : _ref$fontSize,
      _ref$bold = _ref.bold,
      bold = _ref$bold === void 0 ? false : _ref$bold,
      _ref$textTransform = _ref.textTransform,
      textTransform = _ref$textTransform === void 0 ? 'none' : _ref$textTransform,
      props = _objectWithoutProperties(_ref, ["color", "fontSize", "bold", "textTransform"]);

  return _objectSpread({}, (0, _Link.linkStyle)(theme, _objectSpread({
    bold: bold,
    color: color,
    fontSize: fontSize,
    textTransform: textTransform
  }, props)));
};

exports.textLinkStyle = textLinkStyle;

var TextLink = function TextLink(props) {
  return (0, _core.jsx)("a", _extends({
    css: function css(theme) {
      return textLinkStyle(theme, props);
    }
  }, (0, _Link.filterLinkProps)(props)));
};

exports.TextLink = TextLink;
//# sourceMappingURL=TextLink.js.map