#!/bin/sh
export PATH='/usr/local/sbin:/usr/local/bin:/usr/bin:/usr/bin/site_perl:/usr/bin/vendor_perl:/usr/bin/core_perl'
echo 'name:                 xmobar
version:              0.39
visibility:           public
id:                   xmobar-0.39-1ozYzFfRdw75qqmhieNDuE
key:                  xmobar-0.39-1ozYzFfRdw75qqmhieNDuE
license:              BSD-3-Clause
maintainer:           Jose A. Ortega Ruiz <jao@gnu.org>
author:               Andrea Rossato and Jose A. Ortega Ruiz
homepage:             http://xmobar.org
synopsis:             A Minimalistic Text Based Status Bar
description:
    Xmobar is a minimalistic text based status bar.

    Inspired by the Ion3 status bar, it supports similar
    features, like dynamic color management, output templates,
    and extensibility through plugins.

category:             System
abi:                  2b1e601fd4c53188177c04b871fdd02d
exposed:              True
exposed-modules:
    Xmobar Xmobar.Plugins.Monitors.Common
    Xmobar.Plugins.Monitors.Common.Run
    Xmobar.Plugins.Monitors.Common.Types Xmobar.Plugins.Monitors.Cpu

hidden-modules:
    Paths_xmobar Xmobar.Config.Types Xmobar.Config.Parse
    Xmobar.Run.Types Xmobar.Run.Template Xmobar.Run.Exec
    Xmobar.Run.Command Xmobar.Run.Runnable Xmobar.App.EventLoop
    Xmobar.App.Config Xmobar.App.Main Xmobar.App.Opts
    Xmobar.App.Compile Xmobar.App.Timer Xmobar.System.Utils
    Xmobar.System.StatFS Xmobar.System.Environment
    Xmobar.System.Localize Xmobar.System.Signal Xmobar.System.Kbd
    Xmobar.X11.Actions Xmobar.X11.Events Xmobar.X11.Parsers
    Xmobar.X11.Types Xmobar.X11.Text Xmobar.X11.Bitmap
    Xmobar.X11.ColorCache Xmobar.X11.Window Xmobar.X11.Draw
    Xmobar.Plugins.BufferedPipeReader Xmobar.Plugins.CommandReader
    Xmobar.Plugins.Date Xmobar.Plugins.EWMH Xmobar.Plugins.HandleReader
    Xmobar.Plugins.PipeReader Xmobar.Plugins.MarqueePipeReader
    Xmobar.Plugins.StdinReader Xmobar.Plugins.XMonadLog
    Xmobar.Plugins.Kbd Xmobar.Plugins.Locks Xmobar.Plugins.NotmuchMail
    Xmobar.Plugins.Monitors Xmobar.Plugins.Monitors.Batt
    Xmobar.Plugins.Monitors.Common.Output
    Xmobar.Plugins.Monitors.Common.Parsers
    Xmobar.Plugins.Monitors.Common.Files
    Xmobar.Plugins.Monitors.CoreTemp Xmobar.Plugins.Monitors.K10Temp
    Xmobar.Plugins.Monitors.CpuFreq Xmobar.Plugins.Monitors.Disk
    Xmobar.Plugins.Monitors.Mem Xmobar.Plugins.Monitors.MultiCoreTemp
    Xmobar.Plugins.Monitors.MultiCpu Xmobar.Plugins.Monitors.Net
    Xmobar.Plugins.Monitors.Swap Xmobar.Plugins.Monitors.Thermal
    Xmobar.Plugins.Monitors.ThermalZone Xmobar.Plugins.Monitors.Top
    Xmobar.Plugins.Monitors.Uptime Xmobar.Plugins.Monitors.Bright
    Xmobar.Plugins.Monitors.CatInt Xmobar.X11.MinXft
    Xmobar.Plugins.Mail Xmobar.Plugins.MBox
    Xmobar.Plugins.Monitors.Wireless Xmobar.Plugins.Monitors.MPD
    Xmobar.Plugins.Monitors.Volume Xmobar.Plugins.Monitors.Alsa
    Xmobar.Plugins.DateZone Xmobar.Plugins.Monitors.Mpris
    Xmobar.System.DBus Xmobar.X11.XPMFile
    Xmobar.Plugins.Monitors.Weather

import-dirs:          /usr/lib/ghc-9.0.1/site-local/xmobar-0.39
library-dirs:         /usr/lib/ghc-9.0.1/site-local/xmobar-0.39
dynamic-library-dirs: /usr/lib
data-dir:             /usr/share/x86_64-linux-ghc-9.0.1/xmobar-0.39
hs-libraries:         HSxmobar-0.39-1ozYzFfRdw75qqmhieNDuE
extra-libraries:      Xrandr Xrender Xpm
depends:
    X11-1.10.1-KOexKqfvsIxF1vDZupKBH4
    X11-xft-0.3.1-JEfIMbOM9hM4IVCmV6QHwt
    alsa-core-0.5.0.1-EyKLeSfRKRzH2VWenP6BXN
    alsa-mixer-0.3.0-FRoXzn3393p3cbapVA5vjF
    async-2.2.3-IdiNIvUG6Je7aMAPJeWE0D base-4.15.0.0
    bytestring-0.10.12.1 cereal-0.5.8.2-61j1a5W2ABqDRz8HqQdVx7
    containers-0.6.4.1 dbus-1.2.21-51CZLXkyvGcE14UAn0m6oF
    directory-1.3.6.1
    extensible-exceptions-0.1.1.4-78NMIT9qofYFWl0e48Yw92
    filepath-1.4.2.1 hinotify-0.4.1-67XmGS5l0BT5Vr3oZJ3ZMv
    http-client-tls-0.3.5.3-E3YrvnwOLk7FnDgjHH7fkr
    http-conduit-2.3.8-CUEm0yFAAfcJU3pZch3I0b
    http-types-0.12.3-5xSWCbzPZMJ3FKkHNvWW2m
    libmpd-0.10.0.0-EqtdX3K2GHd9xayFX7ajS8 mtl-2.2.2
    netlink-1.1.1.0-BK7RuyFxejGFUphaOiYKqC
    old-locale-1.0.0.7-8b6vATcbl2rGNT5WzdAV1N parsec-3.1.14.0
    parsec-numbers-0.1.0-2jeOcSFcZFFAnSYi7wm3ZC process-1.6.11.0
    regex-compat-0.95.2.1-AyC0wJj3rmJIrop9pFbSaj stm-2.5.0.0 time-1.9.3
    timezone-olson-0.2.0-AoWMH3XDF8eIKokakRudJH
    timezone-series-0.1.9-BOaWIUAL0b77nThbCcBvws transformers-0.5.6.2
    unix-2.7.2.2 utf8-string-1.0.2-FSV4F6pxd5y7PjtRkbEpDf

haddock-interfaces:
    /usr/share/doc/x86_64-linux-ghc-9.0.1/xmobar-0.39/html/xmobar.haddock

haddock-html:         /usr/share/doc/x86_64-linux-ghc-9.0.1/xmobar-0.39/html
' | '/usr/bin/ghc-pkg' 'update' '--force' '-' '--global' '--no-user-package-db' "$@"

