//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.6
//
// <auto-generated>
//
// Generated from file `Session.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

#ifndef __IceGrid_Session_h__
#define __IceGrid_Session_h__

#include <IceUtil/PushDisableWarnings.h>
#include <Ice/ProxyF.h>
#include <Ice/ObjectF.h>
#include <Ice/ValueF.h>
#include <Ice/Exception.h>
#include <Ice/LocalObject.h>
#include <Ice/StreamHelpers.h>
#include <Ice/Comparable.h>
#include <Ice/Proxy.h>
#include <Ice/Object.h>
#include <Ice/GCObject.h>
#include <Ice/Value.h>
#include <Ice/Incoming.h>
#include <Ice/IncomingAsync.h>
#include <Ice/FactoryTableInit.h>
#include <IceUtil/ScopedArray.h>
#include <Ice/Optional.h>
#include <Ice/ExceptionHelpers.h>
#include <Ice/SlicedDataF.h>
#include <Glacier2/Session.h>
#include <IceGrid/Exception.h>
#include <IceUtil/UndefSysMacros.h>
#include <IceGrid/Config.h>

#ifndef ICE_IGNORE_VERSION
#   if ICE_INT_VERSION / 100 != 307
#       error Ice version mismatch!
#   endif
#   if ICE_INT_VERSION % 100 >= 50
#       error Beta header file detected
#   endif
#   if ICE_INT_VERSION % 100 < 6
#       error Ice patch level mismatch!
#   endif
#endif

#ifndef ICEGRID_API
#   if defined(ICE_STATIC_LIBS)
#       define ICEGRID_API /**/
#   elif defined(ICEGRID_API_EXPORTS)
#       define ICEGRID_API ICE_DECLSPEC_EXPORT
#   else
#       define ICEGRID_API ICE_DECLSPEC_IMPORT
#   endif
#endif

#ifdef ICE_CPP11_MAPPING // C++11 mapping

namespace IceGrid
{

class Session;
class SessionPrx;

}

namespace IceGrid
{

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <code>SessionManager</code>
 * object.
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Session : public virtual ::Glacier2::Session
{
public:

    using ProxyType = SessionPrx;

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(::std::string id, const ::Ice::Current& current) const override;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector<::std::string> ice_ids(const ::Ice::Current& current) const override;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual ::std::string ice_id(const ::Ice::Current& current) const override;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param current The Current object for the invocation.
     * @see Registry#getSessionTimeout
     */
    virtual void keepAlive(const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AllocationException Raised if the object can't be
     * allocated.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    virtual void allocateObjectByIdAsync(::Ice::Identity id, ::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_allocateObjectById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param response The response callback.
     * @param exception The exception callback.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AllocationException Raised if the object could not be allocated.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    virtual void allocateObjectByTypeAsync(::std::string type, ::std::function<void(const ::std::shared_ptr<::Ice::ObjectPrx>& returnValue)> response, ::std::function<void(::std::exception_ptr)> exception, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_allocateObjectByType(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     */
    virtual void releaseObject(::Ice::Identity id, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_releaseObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param current The Current object for the invocation.
     */
    virtual void setAllocationTimeout(int timeout, const ::Ice::Current& current) = 0;
    /// \cond INTERNAL
    bool _iceD_setAllocationTimeout(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&) override;
    /// \endcond
};

}

namespace IceGrid
{

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <code>SessionManager</code>
 * object.
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICE_CLASS(ICEGRID_API) SessionPrx : public virtual ::Ice::Proxy<SessionPrx, ::Glacier2::SessionPrx>
{
public:

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @see Registry#getSessionTimeout
     */
    void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &SessionPrx::_iceI_keepAlive, context).get();
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see Registry#getSessionTimeout
     */
    template<template<typename> class P = ::std::promise>
    auto keepAliveAsync(const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &SessionPrx::_iceI_keepAlive, context);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see Registry#getSessionTimeout
     */
    ::std::function<void()>
    keepAliveAsync(::std::function<void()> response,
                   ::std::function<void(::std::exception_ptr)> ex = nullptr,
                   ::std::function<void(bool)> sent = nullptr,
                   const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::SessionPrx::_iceI_keepAlive, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_keepAlive(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Context&);
    /// \endcond

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * @throws IceGrid::AllocationException Raised if the object can't be
     * allocated.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::std::shared_ptr<::Ice::ObjectPrx> allocateObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &SessionPrx::_iceI_allocateObjectById, id, context).get();
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    template<template<typename> class P = ::std::promise>
    auto allocateObjectByIdAsync(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &SessionPrx::_iceI_allocateObjectById, id, context);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::std::function<void()>
    allocateObjectByIdAsync(const ::Ice::Identity& id,
                            ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                            ::std::function<void(::std::exception_ptr)> ex = nullptr,
                            ::std::function<void(bool)> sent = nullptr,
                            const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::SessionPrx::_iceI_allocateObjectById, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_allocateObjectById(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * @throws IceGrid::AllocationException Raised if the object could not be allocated.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::std::shared_ptr<::Ice::ObjectPrx> allocateObjectByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(true, this, &SessionPrx::_iceI_allocateObjectByType, type, context).get();
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    template<template<typename> class P = ::std::promise>
    auto allocateObjectByTypeAsync(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<::std::shared_ptr<::Ice::ObjectPrx>>>().get_future())
    {
        return _makePromiseOutgoing<::std::shared_ptr<::Ice::ObjectPrx>, P>(false, this, &SessionPrx::_iceI_allocateObjectByType, type, context);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::std::function<void()>
    allocateObjectByTypeAsync(const ::std::string& type,
                              ::std::function<void(::std::shared_ptr<::Ice::ObjectPrx>)> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<::std::shared_ptr<::Ice::ObjectPrx>>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::SessionPrx::_iceI_allocateObjectByType, type, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_allocateObjectByType(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<::std::shared_ptr<::Ice::ObjectPrx>>>&, const ::std::string&, const ::Ice::Context&);
    /// \endcond

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     */
    void releaseObject(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &SessionPrx::_iceI_releaseObject, id, context).get();
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto releaseObjectAsync(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &SessionPrx::_iceI_releaseObject, id, context);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    releaseObjectAsync(const ::Ice::Identity& id,
                       ::std::function<void()> response,
                       ::std::function<void(::std::exception_ptr)> ex = nullptr,
                       ::std::function<void(bool)> sent = nullptr,
                       const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::SessionPrx::_iceI_releaseObject, id, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_releaseObject(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, const ::Ice::Identity&, const ::Ice::Context&);
    /// \endcond

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     */
    void setAllocationTimeout(int timeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        _makePromiseOutgoing<void>(true, this, &SessionPrx::_iceI_setAllocationTimeout, timeout, context).get();
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     * @return The future object for the invocation.
     */
    template<template<typename> class P = ::std::promise>
    auto setAllocationTimeoutAsync(int timeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
        -> decltype(::std::declval<P<void>>().get_future())
    {
        return _makePromiseOutgoing<void, P>(false, this, &SessionPrx::_iceI_setAllocationTimeout, timeout, context);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param response The response callback.
     * @param ex The exception callback.
     * @param sent The sent callback.
     * @param context The Context map to send with the invocation.
     * @return A function that can be called to cancel the invocation locally.
     */
    ::std::function<void()>
    setAllocationTimeoutAsync(int timeout,
                              ::std::function<void()> response,
                              ::std::function<void(::std::exception_ptr)> ex = nullptr,
                              ::std::function<void(bool)> sent = nullptr,
                              const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _makeLamdaOutgoing<void>(std::move(response), std::move(ex), std::move(sent), this, &IceGrid::SessionPrx::_iceI_setAllocationTimeout, timeout, context);
    }

    /// \cond INTERNAL
    ICE_MEMBER(ICEGRID_API) void _iceI_setAllocationTimeout(const ::std::shared_ptr<::IceInternal::OutgoingAsyncT<void>>&, int, const ::Ice::Context&);
    /// \endcond

    /**
     * Obtains the Slice type ID of this interface.
     * @return The fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:

    /// \cond INTERNAL
    SessionPrx() = default;
    friend ::std::shared_ptr<SessionPrx> IceInternal::createProxy<SessionPrx>();

    ICE_MEMBER(ICEGRID_API) virtual ::std::shared_ptr<::Ice::ObjectPrx> _newInstance() const override;
    /// \endcond
};

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

/// \cond INTERNAL
namespace IceGrid
{

using SessionPtr = ::std::shared_ptr<Session>;
using SessionPrxPtr = ::std::shared_ptr<SessionPrx>;

}
/// \endcond

#else // C++98 mapping

namespace IceProxy
{

namespace IceGrid
{

class Session;
/// \cond INTERNAL
ICEGRID_API void _readProxy(::Ice::InputStream*, ::IceInternal::ProxyHandle< Session>&);
ICEGRID_API ::IceProxy::Ice::Object* upCast(Session*);
/// \endcond

}

}

namespace IceGrid
{

class Session;
/// \cond INTERNAL
ICEGRID_API ::Ice::Object* upCast(Session*);
/// \endcond
typedef ::IceInternal::Handle< Session> SessionPtr;
typedef ::IceInternal::ProxyHandle< ::IceProxy::IceGrid::Session> SessionPrx;
typedef SessionPrx SessionPrxPtr;
/// \cond INTERNAL
ICEGRID_API void _icePatchObjectPtr(SessionPtr&, const ::Ice::ObjectPtr&);
/// \endcond

}

namespace IceGrid
{

/**
 * AMD callback class for IceGrid::Session::allocateObjectById_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEGRID_API AMD_Session_allocateObjectById : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Session_allocateObjectById();

    /**
     * Call ice_response for a successful completion.
     * @param result The proxy of the allocated object.
     */
    virtual void ice_response(const ::Ice::ObjectPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Session_allocateObjectById> AMD_Session_allocateObjectByIdPtr;

/**
 * AMD callback class for IceGrid::Session::allocateObjectByType_async.
 * Call the ice_response method for a successful completion, or the ice_exception
 * method in the case of an error.
 */
class ICEGRID_API AMD_Session_allocateObjectByType : public virtual ::Ice::AMDCallback
{
public:

    virtual ~AMD_Session_allocateObjectByType();

    /**
     * Call ice_response for a successful completion.
     * @param result The proxy of the allocated object.
     */
    virtual void ice_response(const ::Ice::ObjectPrx& result) = 0;
};

typedef ::IceUtil::Handle< ::IceGrid::AMD_Session_allocateObjectByType> AMD_Session_allocateObjectByTypePtr;

}

/// \cond INTERNAL
namespace IceAsync
{

namespace IceGrid
{

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEGRID_API AMD_Session_allocateObjectById : public ::IceGrid::AMD_Session_allocateObjectById, public ::IceInternal::IncomingAsync
{
public:

    AMD_Session_allocateObjectById(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(push)
#   pragma warning(disable:4239)
#endif

class ICEGRID_API AMD_Session_allocateObjectByType : public ::IceGrid::AMD_Session_allocateObjectByType, public ::IceInternal::IncomingAsync
{
public:

    AMD_Session_allocateObjectByType(::IceInternal::Incoming&);

    virtual void ice_response(const ::Ice::ObjectPrx&);
};

#if defined(_MSC_VER) && (_MSC_VER >= 1900)
#   pragma warning(pop)
#endif

}

}
/// \endcond

namespace IceGrid
{

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Session::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_keepAlive.
 */
class Callback_Session_keepAlive_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_keepAlive_Base> Callback_Session_keepAlivePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Session::begin_allocateObjectById.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_allocateObjectById.
 */
class Callback_Session_allocateObjectById_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_allocateObjectById_Base> Callback_Session_allocateObjectByIdPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Session::begin_allocateObjectByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_allocateObjectByType.
 */
class Callback_Session_allocateObjectByType_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_allocateObjectByType_Base> Callback_Session_allocateObjectByTypePtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Session::begin_releaseObject.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_releaseObject.
 */
class Callback_Session_releaseObject_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_releaseObject_Base> Callback_Session_releaseObjectPtr;

/**
 * Base class for asynchronous callback wrapper classes used for calls to
 * IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_setAllocationTimeout.
 */
class Callback_Session_setAllocationTimeout_Base : public virtual ::IceInternal::CallbackBase { };
typedef ::IceUtil::Handle< Callback_Session_setAllocationTimeout_Base> Callback_Session_setAllocationTimeoutPtr;

}

namespace IceProxy
{

namespace IceGrid
{

class ICE_CLASS(ICEGRID_API) Session : public virtual ::Ice::Proxy<Session, ::IceProxy::Glacier2::Session>
{
public:

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @see Registry#getSessionTimeout
     */
    ICE_MEMBER(ICEGRID_API) void keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_keepAlive(_iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_keepAlive(context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, cb, cookie);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::IceGrid::Callback_Session_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see Registry#getSessionTimeout
     */
    ::Ice::AsyncResultPtr begin_keepAlive(const ::Ice::Context& context, const ::IceGrid::Callback_Session_keepAlivePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_keepAlive(context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_keepAlive.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_keepAlive(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_keepAlive(const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * @throws IceGrid::AllocationException Raised if the object can't be
     * allocated.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx allocateObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_allocateObjectById(_iceI_begin_allocateObjectById(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_allocateObjectById(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(id, context, cb, cookie);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& id, const ::IceGrid::Callback_Session_allocateObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param id The identity of the object to allocate.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectById(const ::Ice::Identity& id, const ::Ice::Context& context, const ::IceGrid::Callback_Session_allocateObjectByIdPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectById(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_allocateObjectById.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy of the allocated object.
     * @throws IceGrid::AllocationException Raised if the object can't be
     * allocated.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_allocateObjectById(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_allocateObjectById(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The proxy of the allocated object.
     * @throws IceGrid::AllocationException Raised if the object could not be allocated.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx allocateObjectByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return end_allocateObjectByType(_iceI_begin_allocateObjectByType(type, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& type, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_allocateObjectByType(type, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& type, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& type, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(type, context, cb, cookie);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& type, const ::IceGrid::Callback_Session_allocateObjectByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(type, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param type The type of the object.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    ::Ice::AsyncResultPtr begin_allocateObjectByType(const ::std::string& type, const ::Ice::Context& context, const ::IceGrid::Callback_Session_allocateObjectByTypePtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_allocateObjectByType(type, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_allocateObjectByType.
     * @param result The asynchronous result object for the invocation.
     * @return The proxy of the allocated object.
     * @throws IceGrid::AllocationException Raised if the object could not be allocated.
     */
    ICE_MEMBER(ICEGRID_API) ::Ice::ObjectPrx end_allocateObjectByType(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_allocateObjectByType(const ::std::string&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @throws IceGrid::AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) void releaseObject(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_releaseObject(_iceI_begin_releaseObject(id, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& id, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_releaseObject(id, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& id, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& id, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(id, context, cb, cookie);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& id, const ::IceGrid::Callback_Session_releaseObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(id, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_releaseObject(const ::Ice::Identity& id, const ::Ice::Context& context, const ::IceGrid::Callback_Session_releaseObjectPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_releaseObject(id, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_releaseObject.
     * @param result The asynchronous result object for the invocation.
     * @throws IceGrid::AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     */
    ICE_MEMBER(ICEGRID_API) void end_releaseObject(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_releaseObject(const ::Ice::Identity&, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void setAllocationTimeout(::Ice::Int timeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        end_setAllocationTimeout(_iceI_begin_setAllocationTimeout(timeout, context, ::IceInternal::dummyCallback, 0, true));
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int timeout, const ::Ice::Context& context = ::Ice::noExplicitContext)
    {
        return _iceI_begin_setAllocationTimeout(timeout, context, ::IceInternal::dummyCallback, 0);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int timeout, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(timeout, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int timeout, const ::Ice::Context& context, const ::Ice::CallbackPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(timeout, context, cb, cookie);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int timeout, const ::IceGrid::Callback_Session_setAllocationTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(timeout, ::Ice::noExplicitContext, cb, cookie);
    }

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param context The Context map to send with the invocation.
     * @param cb Asynchronous callback object.
     * @param cookie User-defined data to associate with the invocation.
     * @return The asynchronous result object for the invocation.
     */
    ::Ice::AsyncResultPtr begin_setAllocationTimeout(::Ice::Int timeout, const ::Ice::Context& context, const ::IceGrid::Callback_Session_setAllocationTimeoutPtr& cb, const ::Ice::LocalObjectPtr& cookie = 0)
    {
        return _iceI_begin_setAllocationTimeout(timeout, context, cb, cookie);
    }

    /**
     * Completes an invocation of begin_setAllocationTimeout.
     * @param result The asynchronous result object for the invocation.
     */
    ICE_MEMBER(ICEGRID_API) void end_setAllocationTimeout(const ::Ice::AsyncResultPtr& result);

private:

    ICE_MEMBER(ICEGRID_API) ::Ice::AsyncResultPtr _iceI_begin_setAllocationTimeout(::Ice::Int, const ::Ice::Context&, const ::IceInternal::CallbackBasePtr&, const ::Ice::LocalObjectPtr& cookie = 0, bool sync = false);

public:

    /**
     * Obtains the Slice type ID corresponding to this interface.
     * @return A fully-scoped type ID.
     */
    ICE_MEMBER(ICEGRID_API) static const ::std::string& ice_staticId();

protected:
    /// \cond INTERNAL

    ICE_MEMBER(ICEGRID_API) virtual ::IceProxy::Ice::Object* _newInstance() const;
    /// \endcond
};

}

}

namespace IceGrid
{

/**
 * A session object is used by IceGrid clients to allocate and
 * release objects. Client sessions are created either via the
 * {@link Registry} object or via the registry client <code>SessionManager</code>
 * object.
 * @see Registry
 * \headerfile IceGrid/IceGrid.h
 */
class ICEGRID_API Session : virtual public ::Glacier2::Session
{
public:

    typedef SessionPrx ProxyType;
    typedef SessionPtr PointerType;

    virtual ~Session();

#ifdef ICE_CPP11_COMPILER
    Session() = default;
    Session(const Session&) = default;
    Session& operator=(const Session&) = default;
#endif

    /**
     * Determines whether this object supports an interface with the given Slice type ID.
     * @param id The fully-scoped Slice type ID.
     * @param current The Current object for the invocation.
     * @return True if this object supports the interface, false, otherwise.
     */
    virtual bool ice_isA(const ::std::string& id, const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a list of the Slice type IDs representing the interfaces supported by this object.
     * @param current The Current object for the invocation.
     * @return A list of fully-scoped type IDs.
     */
    virtual ::std::vector< ::std::string> ice_ids(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains a Slice type ID representing the most-derived interface supported by this object.
     * @param current The Current object for the invocation.
     * @return A fully-scoped type ID.
     */
    virtual const ::std::string& ice_id(const ::Ice::Current& current = ::Ice::emptyCurrent) const;

    /**
     * Obtains the Slice type ID corresponding to this class.
     * @return A fully-scoped type ID.
     */
    static const ::std::string& ice_staticId();

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param current The Current object for the invocation.
     * @see Registry#getSessionTimeout
     */
    virtual void keepAlive(const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_keepAlive(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Allocate an object. Depending on the allocation timeout, this
     * operation might hang until the object is available or until the
     * timeout is reached.
     * @param cb The AMD callback object for the invocation.
     * @param id The identity of the object to allocate.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AllocationException Raised if the object can't be
     * allocated.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    virtual void allocateObjectById_async(const ::IceGrid::AMD_Session_allocateObjectByIdPtr& cb, const ::Ice::Identity& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_allocateObjectById(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Allocate an object with the given type. Depending on the
     * allocation timeout, this operation can block until an object
     * becomes available or until the timeout is reached.
     * @param cb The AMD callback object for the invocation.
     * @param type The type of the object.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AllocationException Raised if the object could not be allocated.
     * @see #setAllocationTimeout
     * @see #releaseObject
     */
    virtual void allocateObjectByType_async(const ::IceGrid::AMD_Session_allocateObjectByTypePtr& cb, const ::std::string& type, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_allocateObjectByType(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Release an object that was allocated using <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code>.
     * @param id The identity of the object to release.
     * @param current The Current object for the invocation.
     * @throws IceGrid::AllocationException Raised if the given object can't be
     * released. This might happen if the object isn't allocatable or
     * isn't allocated by the session.
     * @throws IceGrid::ObjectNotRegisteredException Raised if the object with
     * the given identity is not registered with the registry.
     */
    virtual void releaseObject(const ::Ice::Identity& id, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_releaseObject(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /**
     * Set the allocation timeout. If no objects are available for an
     * allocation request, a call to <code>allocateObjectById</code> or
     * <code>allocateObjectByType</code> will block for the duration of this
     * timeout.
     * @param timeout The timeout in milliseconds.
     * @param current The Current object for the invocation.
     */
    virtual void setAllocationTimeout(::Ice::Int timeout, const ::Ice::Current& current = ::Ice::emptyCurrent) = 0;
    /// \cond INTERNAL
    bool _iceD_setAllocationTimeout(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

    /// \cond INTERNAL
    virtual bool _iceDispatch(::IceInternal::Incoming&, const ::Ice::Current&);
    /// \endcond

protected:

    /// \cond STREAM
    virtual void _iceWriteImpl(::Ice::OutputStream*) const;
    virtual void _iceReadImpl(::Ice::InputStream*);
    /// \endcond
};

/// \cond INTERNAL
inline bool operator==(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) == static_cast<const ::Ice::Object&>(rhs);
}

inline bool operator<(const Session& lhs, const Session& rhs)
{
    return static_cast<const ::Ice::Object&>(lhs) < static_cast<const ::Ice::Object&>(rhs);
}
/// \endcond

}

/// \cond STREAM
namespace Ice
{

}
/// \endcond

namespace IceGrid
{

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Session::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_keepAlive.
 */
template<class T>
class CallbackNC_Session_keepAlive : public Callback_Session_keepAlive_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_keepAlive<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Session::begin_keepAlive.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_keepAlive.
 */
template<class T, typename CT>
class Callback_Session_keepAlive : public Callback_Session_keepAlive_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_keepAlive(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_keepAlive.
 */
template<class T, typename CT> Callback_Session_keepAlivePtr
newCallback_Session_keepAlive(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_keepAlive<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Session::begin_allocateObjectById.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_allocateObjectById.
 */
template<class T>
class CallbackNC_Session_allocateObjectById : public Callback_Session_allocateObjectById_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Session_allocateObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionPrx proxy = SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectById.
 */
template<class T> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectById.
 */
template<class T> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectById<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Session::begin_allocateObjectById.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_allocateObjectById.
 */
template<class T, typename CT>
class Callback_Session_allocateObjectById : public Callback_Session_allocateObjectById_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Session_allocateObjectById(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionPrx proxy = SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectById(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectById.
 */
template<class T, typename CT> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectById.
 */
template<class T, typename CT> Callback_Session_allocateObjectByIdPtr
newCallback_Session_allocateObjectById(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectById<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Session::begin_allocateObjectByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_allocateObjectByType.
 */
template<class T>
class CallbackNC_Session_allocateObjectByType : public Callback_Session_allocateObjectByType_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&);

    CallbackNC_Session_allocateObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionPrx proxy = SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)(ret);
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectByType.
 */
template<class T> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectByType<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectByType.
 */
template<class T> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_allocateObjectByType<T>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Session::begin_allocateObjectByType.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_allocateObjectByType.
 */
template<class T, typename CT>
class Callback_Session_allocateObjectByType : public Callback_Session_allocateObjectByType_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const ::Ice::ObjectPrx&, const CT&);

    Callback_Session_allocateObjectByType(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionPrx proxy = SessionPrx::uncheckedCast(result->getProxy());
        ::Ice::ObjectPrx ret;
        try
        {
            ret = proxy->end_allocateObjectByType(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(ret, CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectByType.
 */
template<class T, typename CT> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(const IceUtil::Handle<T>& instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectByType<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_allocateObjectByType.
 */
template<class T, typename CT> Callback_Session_allocateObjectByTypePtr
newCallback_Session_allocateObjectByType(T* instance, void (T::*cb)(const ::Ice::ObjectPrx&, const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_allocateObjectByType<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Session::begin_releaseObject.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_releaseObject.
 */
template<class T>
class CallbackNC_Session_releaseObject : public Callback_Session_releaseObject_Base, public ::IceInternal::TwowayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_releaseObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallbackNC<T>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionPrx proxy = SessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_releaseObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::CallbackNC<T>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::CallbackNC<T>::_callback.get()->*_response)();
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_releaseObject<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Session::begin_releaseObject.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_releaseObject.
 */
template<class T, typename CT>
class Callback_Session_releaseObject : public Callback_Session_releaseObject_Base, public ::IceInternal::TwowayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_releaseObject(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::TwowayCallback<T, CT>(obj, cb != 0, excb, sentcb), _response(cb)
    {
    }

    /// \cond INTERNAL
    virtual void completed(const ::Ice::AsyncResultPtr& result) const
    {
        SessionPrx proxy = SessionPrx::uncheckedCast(result->getProxy());
        try
        {
            proxy->end_releaseObject(result);
        }
        catch(const ::Ice::Exception& ex)
        {
            ::IceInternal::Callback<T, CT>::exception(result, ex);
            return;
        }
        if(_response)
        {
            (::IceInternal::Callback<T, CT>::_callback.get()->*_response)(CT::dynamicCast(result->getCookie()));
        }
    }
    /// \endcond

private:

    Response _response;
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_releaseObject.
 */
template<class T, typename CT> Callback_Session_releaseObjectPtr
newCallback_Session_releaseObject(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_releaseObject<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class used for calls to
 * IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_setAllocationTimeout.
 */
template<class T>
class CallbackNC_Session_setAllocationTimeout : public Callback_Session_setAllocationTimeout_Base, public ::IceInternal::OnewayCallbackNC<T>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception&);
    typedef void (T::*Sent)(bool);
    typedef void (T::*Response)();

    CallbackNC_Session_setAllocationTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallbackNC<T>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*cb)(), void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*excb)(const ::Ice::Exception&), void (T::*sentcb)(bool) = 0)
{
    return new CallbackNC_Session_setAllocationTimeout<T>(instance, 0, excb, sentcb);
}

/**
 * Type-safe asynchronous callback wrapper class with cookie support used for calls to
 * IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 * Create a wrapper instance by calling ::IceGrid::newCallback_Session_setAllocationTimeout.
 */
template<class T, typename CT>
class Callback_Session_setAllocationTimeout : public Callback_Session_setAllocationTimeout_Base, public ::IceInternal::OnewayCallback<T, CT>
{
public:

    typedef IceUtil::Handle<T> TPtr;

    typedef void (T::*Exception)(const ::Ice::Exception& , const CT&);
    typedef void (T::*Sent)(bool , const CT&);
    typedef void (T::*Response)(const CT&);

    Callback_Session_setAllocationTimeout(const TPtr& obj, Response cb, Exception excb, Sent sentcb)
        : ::IceInternal::OnewayCallback<T, CT>(obj, cb, excb, sentcb)
    {
    }
};

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(const IceUtil::Handle<T>& instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, 0, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param cb The success method of the callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*cb)(const CT&), void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, cb, excb, sentcb);
}

/**
 * Creates a callback wrapper instance that delegates to your object.
 * Use this overload when your callback methods receive a cookie value.
 * @param instance The callback object.
 * @param excb The exception method of the callback object.
 * @param sentcb The sent method of the callback object.
 * @return An object that can be passed to an asynchronous invocation of IceProxy::IceGrid::Session::begin_setAllocationTimeout.
 */
template<class T, typename CT> Callback_Session_setAllocationTimeoutPtr
newCallback_Session_setAllocationTimeout(T* instance, void (T::*excb)(const ::Ice::Exception&, const CT&), void (T::*sentcb)(bool, const CT&) = 0)
{
    return new Callback_Session_setAllocationTimeout<T, CT>(instance, 0, excb, sentcb);
}

}

#endif

#include <IceUtil/PopDisableWarnings.h>
#endif
