//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.6
//
// <auto-generated>
//
// Generated from file `Admin.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * Used by administrative clients to view,
 * update, and receive observer updates from the IceGrid
 * registry. Admin sessions are created either via the {@link Registry}
 * object or via the registry admin <code>SessionManager</code> object.
 *
 * @see Registry
 **/
public interface AdminSessionPrx extends com.zeroc.Glacier2.SessionPrx
{
    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     *
     * @see Registry#getSessionTimeout
     **/
    default void keepAlive()
    {
        keepAlive(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     *
     * @see Registry#getSessionTimeout
     **/
    default void keepAlive(java.util.Map<String, String> context)
    {
        _iceI_keepAliveAsync(context, true).waitForResponse();
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @return A future that will be completed when the invocation completes.
     *
     * @see Registry#getSessionTimeout
     **/
    default java.util.concurrent.CompletableFuture<Void> keepAliveAsync()
    {
        return _iceI_keepAliveAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Keep the session alive. Clients should call this operation
     * regularly to prevent the server from reaping the session.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     *
     * @see Registry#getSessionTimeout
     **/
    default java.util.concurrent.CompletableFuture<Void> keepAliveAsync(java.util.Map<String, String> context)
    {
        return _iceI_keepAliveAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_keepAliveAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "keepAlive", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(false, context, null, null, null);
        return f;
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @return The admin interface proxy.
     **/
    default AdminPrx getAdmin()
    {
        return getAdmin(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @return The admin interface proxy.
     **/
    default AdminPrx getAdmin(java.util.Map<String, String> context)
    {
        return _iceI_getAdminAsync(context, true).waitForResponse();
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @return The admin interface proxy.
     **/
    default java.util.concurrent.CompletableFuture<AdminPrx> getAdminAsync()
    {
        return _iceI_getAdminAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the admin interface. The admin object returned by this
     * operation can only be accessed by the session.
     * @param context The Context map to send with the invocation.
     * @return The admin interface proxy.
     **/
    default java.util.concurrent.CompletableFuture<AdminPrx> getAdminAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAdminAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<AdminPrx> _iceI_getAdminAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<AdminPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAdmin", com.zeroc.Ice.OperationMode.Nonmutating, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     AdminPrx ret;
                     ret = AdminPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     **/
    default com.zeroc.Ice.ObjectPrx getAdminCallbackTemplate()
    {
        return getAdminCallbackTemplate(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     **/
    default com.zeroc.Ice.ObjectPrx getAdminCallbackTemplate(java.util.Map<String, String> context)
    {
        return _iceI_getAdminCallbackTemplateAsync(context, true).waitForResponse();
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getAdminCallbackTemplateAsync()
    {
        return _iceI_getAdminCallbackTemplateAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get a "template" proxy for admin callback objects.
     * An Admin client uses this proxy to set the category of its callback
     * objects, and the published endpoints of the object adapter hosting
     * the admin callback objects.
     * @param context The Context map to send with the invocation.
     * @return A template proxy. The returned proxy is null when the Admin
     * session was established using Glacier2.
     **/
    default java.util.concurrent.CompletableFuture<com.zeroc.Ice.ObjectPrx> getAdminCallbackTemplateAsync(java.util.Map<String, String> context)
    {
        return _iceI_getAdminCallbackTemplateAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> _iceI_getAdminCallbackTemplateAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<com.zeroc.Ice.ObjectPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getAdminCallbackTemplate", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     com.zeroc.Ice.ObjectPrx ret;
                     ret = istr.readProxy();
                     return ret;
                 });
        return f;
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     **/
    default void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
        throws ObserverAlreadyRegisteredException
    {
        setObservers(registryObs, nodeObs, appObs, adptObs, objObs, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     **/
    default void setObservers(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> context)
        throws ObserverAlreadyRegisteredException
    {
        try
        {
            _iceI_setObserversAsync(registryObs, nodeObs, appObs, adptObs, objObs, context, true).waitForResponseOrUserEx();
        }
        catch(ObserverAlreadyRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setObserversAsync(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs)
    {
        return _iceI_setObserversAsync(registryObs, nodeObs, appObs, adptObs, objObs, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Set the observer proxies that receive
     * notifications when the state of the registry
     * or nodes changes.
     * @param registryObs The registry observer.
     * @param nodeObs The node observer.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setObserversAsync(RegistryObserverPrx registryObs, NodeObserverPrx nodeObs, ApplicationObserverPrx appObs, AdapterObserverPrx adptObs, ObjectObserverPrx objObs, java.util.Map<String, String> context)
    {
        return _iceI_setObserversAsync(registryObs, nodeObs, appObs, adptObs, objObs, context, false);
    }

    /**
     * @hidden
     * @param iceP_registryObs -
     * @param iceP_nodeObs -
     * @param iceP_appObs -
     * @param iceP_adptObs -
     * @param iceP_objObs -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_setObserversAsync(RegistryObserverPrx iceP_registryObs, NodeObserverPrx iceP_nodeObs, ApplicationObserverPrx iceP_appObs, AdapterObserverPrx iceP_adptObs, ObjectObserverPrx iceP_objObs, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "setObservers", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_setObservers);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeProxy(iceP_registryObs);
                     ostr.writeProxy(iceP_nodeObs);
                     ostr.writeProxy(iceP_appObs);
                     ostr.writeProxy(iceP_adptObs);
                     ostr.writeProxy(iceP_objObs);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_setObservers =
    {
        ObserverAlreadyRegisteredException.class
    };

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     **/
    default void setObserversByIdentity(com.zeroc.Ice.Identity registryObs, com.zeroc.Ice.Identity nodeObs, com.zeroc.Ice.Identity appObs, com.zeroc.Ice.Identity adptObs, com.zeroc.Ice.Identity objObs)
        throws ObserverAlreadyRegisteredException
    {
        setObserversByIdentity(registryObs, nodeObs, appObs, adptObs, objObs, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @throws ObserverAlreadyRegisteredException Raised if an
     * observer is already registered with this registry.
     **/
    default void setObserversByIdentity(com.zeroc.Ice.Identity registryObs, com.zeroc.Ice.Identity nodeObs, com.zeroc.Ice.Identity appObs, com.zeroc.Ice.Identity adptObs, com.zeroc.Ice.Identity objObs, java.util.Map<String, String> context)
        throws ObserverAlreadyRegisteredException
    {
        try
        {
            _iceI_setObserversByIdentityAsync(registryObs, nodeObs, appObs, adptObs, objObs, context, true).waitForResponseOrUserEx();
        }
        catch(ObserverAlreadyRegisteredException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setObserversByIdentityAsync(com.zeroc.Ice.Identity registryObs, com.zeroc.Ice.Identity nodeObs, com.zeroc.Ice.Identity appObs, com.zeroc.Ice.Identity adptObs, com.zeroc.Ice.Identity objObs)
    {
        return _iceI_setObserversByIdentityAsync(registryObs, nodeObs, appObs, adptObs, objObs, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Set the observer identities that receive
     * notifications the state of the registry
     * or nodes changes. This operation should be used by clients that
     * are using a bidirectional connection to communicate with the
     * session.
     * @param registryObs The registry observer identity.
     * @param nodeObs The node observer identity.
     * @param appObs The application observer.
     * @param adptObs The adapter observer.
     * @param objObs The object observer.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> setObserversByIdentityAsync(com.zeroc.Ice.Identity registryObs, com.zeroc.Ice.Identity nodeObs, com.zeroc.Ice.Identity appObs, com.zeroc.Ice.Identity adptObs, com.zeroc.Ice.Identity objObs, java.util.Map<String, String> context)
    {
        return _iceI_setObserversByIdentityAsync(registryObs, nodeObs, appObs, adptObs, objObs, context, false);
    }

    /**
     * @hidden
     * @param iceP_registryObs -
     * @param iceP_nodeObs -
     * @param iceP_appObs -
     * @param iceP_adptObs -
     * @param iceP_objObs -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_setObserversByIdentityAsync(com.zeroc.Ice.Identity iceP_registryObs, com.zeroc.Ice.Identity iceP_nodeObs, com.zeroc.Ice.Identity iceP_appObs, com.zeroc.Ice.Identity iceP_adptObs, com.zeroc.Ice.Identity iceP_objObs, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "setObserversByIdentity", com.zeroc.Ice.OperationMode.Idempotent, sync, _iceE_setObserversByIdentity);
        f.invoke(true, context, null, ostr -> {
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_registryObs);
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_nodeObs);
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_appObs);
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_adptObs);
                     com.zeroc.Ice.Identity.ice_write(ostr, iceP_objObs);
                 }, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_setObserversByIdentity =
    {
        ObserverAlreadyRegisteredException.class
    };

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @return The current serial.
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     **/
    default int startUpdate()
        throws AccessDeniedException
    {
        return startUpdate(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @return The current serial.
     * @throws AccessDeniedException Raised if the exclusive lock can't be
     * acquired. This might happen if the lock is currently acquired by
     * another session.
     **/
    default int startUpdate(java.util.Map<String, String> context)
        throws AccessDeniedException
    {
        try
        {
            return _iceI_startUpdateAsync(context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @return The current serial.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> startUpdateAsync()
    {
        return _iceI_startUpdateAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Acquires an exclusive lock to start updating the registry applications.
     * @param context The Context map to send with the invocation.
     * @return The current serial.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.Integer> startUpdateAsync(java.util.Map<String, String> context)
    {
        return _iceI_startUpdateAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> _iceI_startUpdateAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.Integer> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "startUpdate", null, sync, _iceE_startUpdate);
        f.invoke(true, context, null, null, istr -> {
                     int ret;
                     ret = istr.readInt();
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_startUpdate =
    {
        AccessDeniedException.class
    };

    /**
     * Finish updating the registry and release the exclusive lock.
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     **/
    default void finishUpdate()
        throws AccessDeniedException
    {
        finishUpdate(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @throws AccessDeniedException Raised if the session doesn't hold the
     * exclusive lock.
     **/
    default void finishUpdate(java.util.Map<String, String> context)
        throws AccessDeniedException
    {
        try
        {
            _iceI_finishUpdateAsync(context, true).waitForResponseOrUserEx();
        }
        catch(AccessDeniedException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> finishUpdateAsync()
    {
        return _iceI_finishUpdateAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Finish updating the registry and release the exclusive lock.
     * @param context The Context map to send with the invocation.
     * @return A future that will be completed when the invocation completes.
     **/
    default java.util.concurrent.CompletableFuture<Void> finishUpdateAsync(java.util.Map<String, String> context)
    {
        return _iceI_finishUpdateAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<Void> _iceI_finishUpdateAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<Void> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "finishUpdate", null, sync, _iceE_finishUpdate);
        f.invoke(true, context, null, null, null);
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_finishUpdate =
    {
        AccessDeniedException.class
    };

    /**
     * Get the name of the registry replica hosting this session.
     * @return The replica name of the registry.
     **/
    default String getReplicaName()
    {
        return getReplicaName(com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @return The replica name of the registry.
     **/
    default String getReplicaName(java.util.Map<String, String> context)
    {
        return _iceI_getReplicaNameAsync(context, true).waitForResponse();
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @return The replica name of the registry.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getReplicaNameAsync()
    {
        return _iceI_getReplicaNameAsync(com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Get the name of the registry replica hosting this session.
     * @param context The Context map to send with the invocation.
     * @return The replica name of the registry.
     **/
    default java.util.concurrent.CompletableFuture<java.lang.String> getReplicaNameAsync(java.util.Map<String, String> context)
    {
        return _iceI_getReplicaNameAsync(context, false);
    }

    /**
     * @hidden
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<java.lang.String> _iceI_getReplicaNameAsync(java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<java.lang.String> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "getReplicaName", com.zeroc.Ice.OperationMode.Idempotent, sync, null);
        f.invoke(true, context, null, null, istr -> {
                     String ret;
                     ret = istr.readString();
                     return ret;
                 });
        return f;
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default FileIteratorPrx openServerLog(String id, String path, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerLog(id, path, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default FileIteratorPrx openServerLog(String id, String path, int count, java.util.Map<String, String> context)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_openServerLogAsync(id, path, count, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openServerLogAsync(String id, String path, int count)
    {
        return _iceI_openServerLogAsync(id, path, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given server log file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param path The path of the log file. A log file can be opened
     * only if it's declared in the server or service deployment
     * descriptor.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openServerLogAsync(String id, String path, int count, java.util.Map<String, String> context)
    {
        return _iceI_openServerLogAsync(id, path, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param iceP_path -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openServerLogAsync(String iceP_id, String iceP_path, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openServerLog", null, sync, _iceE_openServerLog);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                     ostr.writeString(iceP_path);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openServerLog =
    {
        DeploymentException.class,
        FileNotAvailableException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default FileIteratorPrx openServerStdErr(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdErr(id, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default FileIteratorPrx openServerStdErr(String id, int count, java.util.Map<String, String> context)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_openServerStdErrAsync(id, count, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openServerStdErrAsync(String id, int count)
    {
        return _iceI_openServerStdErrAsync(id, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given server stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openServerStdErrAsync(String id, int count, java.util.Map<String, String> context)
    {
        return _iceI_openServerStdErrAsync(id, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openServerStdErrAsync(String iceP_id, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openServerStdErr", null, sync, _iceE_openServerStdErr);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openServerStdErr =
    {
        DeploymentException.class,
        FileNotAvailableException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default FileIteratorPrx openServerStdOut(String id, int count)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        return openServerStdOut(id, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws DeploymentException Raised if the server couldn't be
     * deployed on the node.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     * @throws ServerNotExistException Raised if the server doesn't
     * exist.
     **/
    default FileIteratorPrx openServerStdOut(String id, int count, java.util.Map<String, String> context)
        throws DeploymentException,
               FileNotAvailableException,
               NodeUnreachableException,
               ServerNotExistException
    {
        try
        {
            return _iceI_openServerStdOutAsync(id, count, context, true).waitForResponseOrUserEx();
        }
        catch(DeploymentException ex)
        {
            throw ex;
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(ServerNotExistException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openServerStdOutAsync(String id, int count)
    {
        return _iceI_openServerStdOutAsync(id, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given server stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param id The server id.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openServerStdOutAsync(String id, int count, java.util.Map<String, String> context)
    {
        return _iceI_openServerStdOutAsync(id, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_id -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openServerStdOutAsync(String iceP_id, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openServerStdOut", null, sync, _iceE_openServerStdOut);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_id);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openServerStdOut =
    {
        DeploymentException.class,
        FileNotAvailableException.class,
        NodeUnreachableException.class,
        ServerNotExistException.class
    };

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     **/
    default FileIteratorPrx openNodeStdErr(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdErr(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     **/
    default FileIteratorPrx openNodeStdErr(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_openNodeStdErrAsync(name, count, context, true).waitForResponseOrUserEx();
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openNodeStdErrAsync(String name, int count)
    {
        return _iceI_openNodeStdErrAsync(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given node stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openNodeStdErrAsync(String name, int count, java.util.Map<String, String> context)
    {
        return _iceI_openNodeStdErrAsync(name, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openNodeStdErrAsync(String iceP_name, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openNodeStdErr", null, sync, _iceE_openNodeStdErr);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openNodeStdErr =
    {
        FileNotAvailableException.class,
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     **/
    default FileIteratorPrx openNodeStdOut(String name, int count)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        return openNodeStdOut(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws NodeNotExistException Raised if the node doesn't exist.
     * @throws NodeUnreachableException Raised if the node could not
     * be reached.
     **/
    default FileIteratorPrx openNodeStdOut(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               NodeNotExistException,
               NodeUnreachableException
    {
        try
        {
            return _iceI_openNodeStdOutAsync(name, count, context, true).waitForResponseOrUserEx();
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(NodeNotExistException ex)
        {
            throw ex;
        }
        catch(NodeUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openNodeStdOutAsync(String name, int count)
    {
        return _iceI_openNodeStdOutAsync(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given node stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The node name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openNodeStdOutAsync(String name, int count, java.util.Map<String, String> context)
    {
        return _iceI_openNodeStdOutAsync(name, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openNodeStdOutAsync(String iceP_name, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openNodeStdOut", null, sync, _iceE_openNodeStdOut);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openNodeStdOut =
    {
        FileNotAvailableException.class,
        NodeNotExistException.class,
        NodeUnreachableException.class
    };

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     **/
    default FileIteratorPrx openRegistryStdErr(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdErr(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     **/
    default FileIteratorPrx openRegistryStdErr(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        try
        {
            return _iceI_openRegistryStdErrAsync(name, count, context, true).waitForResponseOrUserEx();
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(RegistryNotExistException ex)
        {
            throw ex;
        }
        catch(RegistryUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openRegistryStdErrAsync(String name, int count)
    {
        return _iceI_openRegistryStdErrAsync(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given registry stderr file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openRegistryStdErrAsync(String name, int count, java.util.Map<String, String> context)
    {
        return _iceI_openRegistryStdErrAsync(name, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openRegistryStdErrAsync(String iceP_name, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openRegistryStdErr", null, sync, _iceE_openRegistryStdErr);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openRegistryStdErr =
    {
        FileNotAvailableException.class,
        RegistryNotExistException.class,
        RegistryUnreachableException.class
    };

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     **/
    default FileIteratorPrx openRegistryStdOut(String name, int count)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        return openRegistryStdOut(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     * @throws FileNotAvailableException Raised if the file can't be
     * read.
     * @throws RegistryNotExistException Raised if the registry
     * doesn't exist.
     * @throws RegistryUnreachableException Raised if the registry
     * could not be reached.
     **/
    default FileIteratorPrx openRegistryStdOut(String name, int count, java.util.Map<String, String> context)
        throws FileNotAvailableException,
               RegistryNotExistException,
               RegistryUnreachableException
    {
        try
        {
            return _iceI_openRegistryStdOutAsync(name, count, context, true).waitForResponseOrUserEx();
        }
        catch(FileNotAvailableException ex)
        {
            throw ex;
        }
        catch(RegistryNotExistException ex)
        {
            throw ex;
        }
        catch(RegistryUnreachableException ex)
        {
            throw ex;
        }
        catch(com.zeroc.Ice.UserException ex)
        {
            throw new com.zeroc.Ice.UnknownUserException(ex.ice_id(), ex);
        }
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openRegistryStdOutAsync(String name, int count)
    {
        return _iceI_openRegistryStdOutAsync(name, count, com.zeroc.Ice.ObjectPrx.noExplicitContext, false);
    }

    /**
     * Open the given registry stdout file for reading. The file can be
     * read with the returned file iterator.
     * @param name The registry name.
     * @param count Specifies where to start reading the file. If
     * negative, the file is read from the begining. If 0 or positive,
     * the file is read from the last <code>count</code> lines.
     * @param context The Context map to send with the invocation.
     * @return An iterator to read the file.
     **/
    default java.util.concurrent.CompletableFuture<FileIteratorPrx> openRegistryStdOutAsync(String name, int count, java.util.Map<String, String> context)
    {
        return _iceI_openRegistryStdOutAsync(name, count, context, false);
    }

    /**
     * @hidden
     * @param iceP_name -
     * @param iceP_count -
     * @param context -
     * @param sync -
     * @return -
     **/
    default com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> _iceI_openRegistryStdOutAsync(String iceP_name, int iceP_count, java.util.Map<String, String> context, boolean sync)
    {
        com.zeroc.IceInternal.OutgoingAsync<FileIteratorPrx> f = new com.zeroc.IceInternal.OutgoingAsync<>(this, "openRegistryStdOut", null, sync, _iceE_openRegistryStdOut);
        f.invoke(true, context, null, ostr -> {
                     ostr.writeString(iceP_name);
                     ostr.writeInt(iceP_count);
                 }, istr -> {
                     FileIteratorPrx ret;
                     ret = FileIteratorPrx.uncheckedCast(istr.readProxy());
                     return ret;
                 });
        return f;
    }

    /** @hidden */
    static final Class<?>[] _iceE_openRegistryStdOut =
    {
        FileNotAvailableException.class,
        RegistryNotExistException.class,
        RegistryUnreachableException.class
    };

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminSessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, ice_staticId(), AdminSessionPrx.class, _AdminSessionPrxI.class);
    }

    /**
     * Contacts the remote server to verify that the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminSessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, context, ice_staticId(), AdminSessionPrx.class, _AdminSessionPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminSessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, ice_staticId(), AdminSessionPrx.class, _AdminSessionPrxI.class);
    }

    /**
     * Contacts the remote server to verify that a facet of the object implements this type.
     * Raises a local exception if a communication error occurs.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @param context The Context map to send with the invocation.
     * @return A proxy for this type, or null if the object does not support this type.
     **/
    static AdminSessionPrx checkedCast(com.zeroc.Ice.ObjectPrx obj, String facet, java.util.Map<String, String> context)
    {
        return com.zeroc.Ice.ObjectPrx._checkedCast(obj, facet, context, ice_staticId(), AdminSessionPrx.class, _AdminSessionPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @return A proxy for this type.
     **/
    static AdminSessionPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, AdminSessionPrx.class, _AdminSessionPrxI.class);
    }

    /**
     * Downcasts the given proxy to this type without contacting the remote server.
     * @param obj The untyped proxy.
     * @param facet The name of the desired facet.
     * @return A proxy for this type.
     **/
    static AdminSessionPrx uncheckedCast(com.zeroc.Ice.ObjectPrx obj, String facet)
    {
        return com.zeroc.Ice.ObjectPrx._uncheckedCast(obj, facet, AdminSessionPrx.class, _AdminSessionPrxI.class);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the per-proxy context.
     * @param newContext The context for the new proxy.
     * @return A proxy with the specified per-proxy context.
     **/
    @Override
    default AdminSessionPrx ice_context(java.util.Map<String, String> newContext)
    {
        return (AdminSessionPrx)_ice_context(newContext);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the adapter ID.
     * @param newAdapterId The adapter ID for the new proxy.
     * @return A proxy with the specified adapter ID.
     **/
    @Override
    default AdminSessionPrx ice_adapterId(String newAdapterId)
    {
        return (AdminSessionPrx)_ice_adapterId(newAdapterId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoints.
     * @param newEndpoints The endpoints for the new proxy.
     * @return A proxy with the specified endpoints.
     **/
    @Override
    default AdminSessionPrx ice_endpoints(com.zeroc.Ice.Endpoint[] newEndpoints)
    {
        return (AdminSessionPrx)_ice_endpoints(newEndpoints);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator cache timeout.
     * @param newTimeout The new locator cache timeout (in seconds).
     * @return A proxy with the specified locator cache timeout.
     **/
    @Override
    default AdminSessionPrx ice_locatorCacheTimeout(int newTimeout)
    {
        return (AdminSessionPrx)_ice_locatorCacheTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the invocation timeout.
     * @param newTimeout The new invocation timeout (in seconds).
     * @return A proxy with the specified invocation timeout.
     **/
    @Override
    default AdminSessionPrx ice_invocationTimeout(int newTimeout)
    {
        return (AdminSessionPrx)_ice_invocationTimeout(newTimeout);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for connection caching.
     * @param newCache <code>true</code> if the new proxy should cache connections; <code>false</code> otherwise.
     * @return A proxy with the specified caching policy.
     **/
    @Override
    default AdminSessionPrx ice_connectionCached(boolean newCache)
    {
        return (AdminSessionPrx)_ice_connectionCached(newCache);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the endpoint selection policy.
     * @param newType The new endpoint selection policy.
     * @return A proxy with the specified endpoint selection policy.
     **/
    @Override
    default AdminSessionPrx ice_endpointSelection(com.zeroc.Ice.EndpointSelectionType newType)
    {
        return (AdminSessionPrx)_ice_endpointSelection(newType);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for how it selects endpoints.
     * @param b If <code>b</code> is <code>true</code>, only endpoints that use a secure transport are
     * used by the new proxy. If <code>b</code> is false, the returned proxy uses both secure and
     * insecure endpoints.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default AdminSessionPrx ice_secure(boolean b)
    {
        return (AdminSessionPrx)_ice_secure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the encoding used to marshal parameters.
     * @param e The encoding version to use to marshal request parameters.
     * @return A proxy with the specified encoding version.
     **/
    @Override
    default AdminSessionPrx ice_encodingVersion(com.zeroc.Ice.EncodingVersion e)
    {
        return (AdminSessionPrx)_ice_encodingVersion(e);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its endpoint selection policy.
     * @param b If <code>b</code> is <code>true</code>, the new proxy will use secure endpoints for invocations
     * and only use insecure endpoints if an invocation cannot be made via secure endpoints. If <code>b</code> is
     * <code>false</code>, the proxy prefers insecure endpoints to secure ones.
     * @return A proxy with the specified selection policy.
     **/
    @Override
    default AdminSessionPrx ice_preferSecure(boolean b)
    {
        return (AdminSessionPrx)_ice_preferSecure(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the router.
     * @param router The router for the new proxy.
     * @return A proxy with the specified router.
     **/
    @Override
    default AdminSessionPrx ice_router(com.zeroc.Ice.RouterPrx router)
    {
        return (AdminSessionPrx)_ice_router(router);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for the locator.
     * @param locator The locator for the new proxy.
     * @return A proxy with the specified locator.
     **/
    @Override
    default AdminSessionPrx ice_locator(com.zeroc.Ice.LocatorPrx locator)
    {
        return (AdminSessionPrx)_ice_locator(locator);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for collocation optimization.
     * @param b <code>true</code> if the new proxy enables collocation optimization; <code>false</code> otherwise.
     * @return A proxy with the specified collocation optimization.
     **/
    @Override
    default AdminSessionPrx ice_collocationOptimized(boolean b)
    {
        return (AdminSessionPrx)_ice_collocationOptimized(b);
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses twoway invocations.
     * @return A proxy that uses twoway invocations.
     **/
    @Override
    default AdminSessionPrx ice_twoway()
    {
        return (AdminSessionPrx)_ice_twoway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses oneway invocations.
     * @return A proxy that uses oneway invocations.
     **/
    @Override
    default AdminSessionPrx ice_oneway()
    {
        return (AdminSessionPrx)_ice_oneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch oneway invocations.
     * @return A proxy that uses batch oneway invocations.
     **/
    @Override
    default AdminSessionPrx ice_batchOneway()
    {
        return (AdminSessionPrx)_ice_batchOneway();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses datagram invocations.
     * @return A proxy that uses datagram invocations.
     **/
    @Override
    default AdminSessionPrx ice_datagram()
    {
        return (AdminSessionPrx)_ice_datagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, but uses batch datagram invocations.
     * @return A proxy that uses batch datagram invocations.
     **/
    @Override
    default AdminSessionPrx ice_batchDatagram()
    {
        return (AdminSessionPrx)_ice_batchDatagram();
    }

    /**
     * Returns a proxy that is identical to this proxy, except for compression.
     * @param co <code>true</code> enables compression for the new proxy; <code>false</code> disables compression.
     * @return A proxy with the specified compression setting.
     **/
    @Override
    default AdminSessionPrx ice_compress(boolean co)
    {
        return (AdminSessionPrx)_ice_compress(co);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection timeout setting.
     * @param t The connection timeout for the proxy in milliseconds.
     * @return A proxy with the specified timeout.
     **/
    @Override
    default AdminSessionPrx ice_timeout(int t)
    {
        return (AdminSessionPrx)_ice_timeout(t);
    }

    /**
     * Returns a proxy that is identical to this proxy, except for its connection ID.
     * @param connectionId The connection ID for the new proxy. An empty string removes the connection ID.
     * @return A proxy with the specified connection ID.
     **/
    @Override
    default AdminSessionPrx ice_connectionId(String connectionId)
    {
        return (AdminSessionPrx)_ice_connectionId(connectionId);
    }

    /**
     * Returns a proxy that is identical to this proxy, except it's a fixed proxy bound
     * the given connection.@param connection The fixed proxy connection.
     * @return A fixed proxy bound to the given connection.
     **/
    @Override
    default AdminSessionPrx ice_fixed(com.zeroc.Ice.Connection connection)
    {
        return (AdminSessionPrx)_ice_fixed(connection);
    }

    static String ice_staticId()
    {
        return "::IceGrid::AdminSession";
    }
}
