//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.6
//
// <auto-generated>
//
// Generated from file `Registry.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceGrid;

/**
 * The IceGrid query interface. This interface is accessible to
 * Ice clients who wish to look up well-known objects.
 **/
public interface Query extends com.zeroc.Ice.Object
{
    /**
     * Find a well-known object by identity.
     * @param id The identity.
     * @param current The Current object for the invocation.
     * @return The proxy or null if no such object has been found.
     **/
    com.zeroc.Ice.ObjectPrx findObjectById(com.zeroc.Ice.Identity id, com.zeroc.Ice.Current current);

    /**
     * Find a well-known object by type. If there are several objects
     * registered for the given type, the object is randomly
     * selected.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     **/
    com.zeroc.Ice.ObjectPrx findObjectByType(String type, com.zeroc.Ice.Current current);

    /**
     * Find a well-known object by type on the least-loaded node. If
     * the registry does not know which node hosts the object
     * (for example, because the object was registered with a direct proxy), the
     * registry assumes the object is hosted on a node that has a load
     * average of 1.0.
     * @param type The object type.
     * @param sample The sampling interval.
     * @param current The Current object for the invocation.
     * @return The proxy or null, if no such object has been found.
     **/
    com.zeroc.Ice.ObjectPrx findObjectByTypeOnLeastLoadedNode(String type, LoadSample sample, com.zeroc.Ice.Current current);

    /**
     * Find all the well-known objects with the given type.
     * @param type The object type.
     * @param current The Current object for the invocation.
     * @return The proxies or an empty sequence, if no such objects
     * have been found.
     **/
    com.zeroc.Ice.ObjectPrx[] findAllObjectsByType(String type, com.zeroc.Ice.Current current);

    /**
     * Find all the object replicas associated with the given
     * proxy. If the given proxy is not an indirect proxy from a
     * replica group, an empty sequence is returned.
     * @param proxy The object proxy.
     * @param current The Current object for the invocation.
     * @return The proxies of each object replica or an empty sequence,
     * if the given proxy is not from a replica group.
     **/
    com.zeroc.Ice.ObjectPrx[] findAllReplicas(com.zeroc.Ice.ObjectPrx proxy, com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceGrid::Query"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceGrid::Query";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findObjectById(Query obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.Identity iceP_id;
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.findObjectById(iceP_id, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findObjectByType(Query obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_type;
        iceP_type = istr.readString();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.findObjectByType(iceP_type, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findObjectByTypeOnLeastLoadedNode(Query obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_type;
        LoadSample iceP_sample;
        iceP_type = istr.readString();
        iceP_sample = LoadSample.ice_read(istr);
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx ret = obj.findObjectByTypeOnLeastLoadedNode(iceP_type, iceP_sample, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        ostr.writeProxy(ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findAllObjectsByType(Query obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_type;
        iceP_type = istr.readString();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx[] ret = obj.findAllObjectsByType(iceP_type, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        com.zeroc.Ice.ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findAllReplicas(Query obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        com.zeroc.Ice.ObjectPrx iceP_proxy;
        iceP_proxy = istr.readProxy();
        inS.endReadParams();
        com.zeroc.Ice.ObjectPrx[] ret = obj.findAllReplicas(iceP_proxy, current);
        com.zeroc.Ice.OutputStream ostr = inS.startWriteParams();
        com.zeroc.Ice.ObjectProxySeqHelper.write(ostr, ret);
        inS.endWriteParams(ostr);
        return inS.setResult(ostr);
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "findAllObjectsByType",
        "findAllReplicas",
        "findObjectById",
        "findObjectByType",
        "findObjectByTypeOnLeastLoadedNode",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_findAllObjectsByType(this, in, current);
            }
            case 1:
            {
                return _iceD_findAllReplicas(this, in, current);
            }
            case 2:
            {
                return _iceD_findObjectById(this, in, current);
            }
            case 3:
            {
                return _iceD_findObjectByType(this, in, current);
            }
            case 4:
            {
                return _iceD_findObjectByTypeOnLeastLoadedNode(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 6:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 7:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 8:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
