//
// Copyright (c) ZeroC, Inc. All rights reserved.
//
//
// Ice version 3.7.6
//
// <auto-generated>
//
// Generated from file `IceDiscovery.ice'
//
// Warning: do not edit this file.
//
// </auto-generated>
//

package com.zeroc.IceDiscovery;

/**
 * The Lookup interface is used by IceDiscovery clients to look for objects
 * and adapters using UDP multicast.
 **/
public interface Lookup extends com.zeroc.Ice.Object
{
    /**
     * Request to find an Ice object
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The object identity.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching object is found.
     * @param current The Current object for the invocation.
     **/
    void findObjectById(String domainId, com.zeroc.Ice.Identity id, LookupReplyPrx reply, com.zeroc.Ice.Current current);

    /**
     * Request to find an object adapter
     * @param domainId The IceDiscovery domain identifier. An IceDiscovery client only
     * replies to requests with a matching domain identifier.
     * @param id The adapter ID.
     * @param reply The proxy of the LookupReply interface that should be used to send
     * the reply if a matching adapter is found.
     * @param current The Current object for the invocation.
     **/
    void findAdapterById(String domainId, String id, LookupReplyPrx reply, com.zeroc.Ice.Current current);

    /** @hidden */
    static final String[] _iceIds =
    {
        "::Ice::Object",
        "::IceDiscovery::Lookup"
    };

    @Override
    default String[] ice_ids(com.zeroc.Ice.Current current)
    {
        return _iceIds;
    }

    @Override
    default String ice_id(com.zeroc.Ice.Current current)
    {
        return ice_staticId();
    }

    static String ice_staticId()
    {
        return "::IceDiscovery::Lookup";
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findObjectById(Lookup obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_domainId;
        com.zeroc.Ice.Identity iceP_id;
        LookupReplyPrx iceP_reply;
        iceP_domainId = istr.readString();
        iceP_id = com.zeroc.Ice.Identity.ice_read(istr);
        iceP_reply = LookupReplyPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.findObjectById(iceP_domainId, iceP_id, iceP_reply, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /**
     * @hidden
     * @param obj -
     * @param inS -
     * @param current -
     * @return -
    **/
    static java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceD_findAdapterById(Lookup obj, final com.zeroc.IceInternal.Incoming inS, com.zeroc.Ice.Current current)
    {
        com.zeroc.Ice.Object._iceCheckMode(com.zeroc.Ice.OperationMode.Idempotent, current.mode);
        com.zeroc.Ice.InputStream istr = inS.startReadParams();
        String iceP_domainId;
        String iceP_id;
        LookupReplyPrx iceP_reply;
        iceP_domainId = istr.readString();
        iceP_id = istr.readString();
        iceP_reply = LookupReplyPrx.uncheckedCast(istr.readProxy());
        inS.endReadParams();
        obj.findAdapterById(iceP_domainId, iceP_id, iceP_reply, current);
        return inS.setResult(inS.writeEmptyParams());
    }

    /** @hidden */
    final static String[] _iceOps =
    {
        "findAdapterById",
        "findObjectById",
        "ice_id",
        "ice_ids",
        "ice_isA",
        "ice_ping"
    };

    /** @hidden */
    @Override
    default java.util.concurrent.CompletionStage<com.zeroc.Ice.OutputStream> _iceDispatch(com.zeroc.IceInternal.Incoming in, com.zeroc.Ice.Current current)
        throws com.zeroc.Ice.UserException
    {
        int pos = java.util.Arrays.binarySearch(_iceOps, current.operation);
        if(pos < 0)
        {
            throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
        }

        switch(pos)
        {
            case 0:
            {
                return _iceD_findAdapterById(this, in, current);
            }
            case 1:
            {
                return _iceD_findObjectById(this, in, current);
            }
            case 2:
            {
                return com.zeroc.Ice.Object._iceD_ice_id(this, in, current);
            }
            case 3:
            {
                return com.zeroc.Ice.Object._iceD_ice_ids(this, in, current);
            }
            case 4:
            {
                return com.zeroc.Ice.Object._iceD_ice_isA(this, in, current);
            }
            case 5:
            {
                return com.zeroc.Ice.Object._iceD_ice_ping(this, in, current);
            }
        }

        assert(false);
        throw new com.zeroc.Ice.OperationNotExistException(current.id, current.facet, current.operation);
    }
}
